/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events.zeromq;

import com.google.common.collect.EvictingQueue;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.events.Event;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.events.Type;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

class UnboundZmqEventBus
implements EventBus {
    private static final Logger LOG = Logger.getLogger(EventBus.class.getName());
    private static final Json JSON = new Json();
    private final ExecutorService executor;
    private final Map<Type, List<Consumer<Event>>> listeners = new ConcurrentHashMap<Type, List<Consumer<Event>>>();
    private final Queue<UUID> recentMessages = EvictingQueue.create((int)128);
    private ZMQ.Socket pub;
    private ZMQ.Socket sub;

    UnboundZmqEventBus(ZContext context, String publishConnection, String subscribeConnection) {
        this.executor = Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r);
            thread.setName("Event Bus");
            thread.setDaemon(true);
            return thread;
        });
        LOG.info(String.format("Connecting to %s and %s", publishConnection, subscribeConnection));
        this.sub = context.createSocket(SocketType.SUB);
        this.sub.setIPv6(this.isSubAddressIPv6(publishConnection));
        this.sub.connect(publishConnection);
        this.sub.subscribe(new byte[0]);
        this.pub = context.createSocket(SocketType.PUB);
        this.pub.setIPv6(this.isSubAddressIPv6(subscribeConnection));
        this.pub.connect(subscribeConnection);
        ZMQ.Poller poller = context.createPoller(1);
        poller.register(this.sub, 1);
        LOG.info("Sockets created");
        AtomicBoolean pollingStarted = new AtomicBoolean(false);
        this.executor.submit(() -> {
            LOG.info("Bus started");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    poller.poll(150L);
                    pollingStarted.lazySet(true);
                    if (!poller.pollin(0)) continue;
                    ZMQ.Socket socket = poller.getSocket(0);
                    Type type = new Type(new String(socket.recv(1), StandardCharsets.UTF_8));
                    UUID id = UUID.fromString(new String(socket.recv(1), StandardCharsets.UTF_8));
                    String data = new String(socket.recv(1), StandardCharsets.UTF_8);
                    Object converted = JSON.toType(data, Object.class);
                    Event event = new Event(id, type, converted);
                    if (this.recentMessages.contains(id)) continue;
                    this.recentMessages.add(id);
                    List<Consumer<Event>> typeListeners = this.listeners.get(type);
                    if (typeListeners == null) continue;
                    typeListeners.parallelStream().forEach(listener -> listener.accept(event));
                }
                catch (Throwable e) {
                    if (e.getCause() != null && e.getCause() instanceof AssertionError) continue;
                    throw e;
                }
            }
        });
        while (!pollingStarted.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isSubAddressIPv6(String connection) {
        try {
            return InetAddress.getByName(new URI(connection).getHost()) instanceof Inet6Address;
        }
        catch (URISyntaxException | UnknownHostException e) {
            LOG.log(Level.WARNING, String.format("Could not determine if the address %s is IPv6 or IPv4", connection), e);
            return false;
        }
    }

    @Override
    public void addListener(Type type, Consumer<Event> onType) {
        Require.nonNull((String)"Event type", (Object)type);
        Require.nonNull((String)"Event listener", onType);
        List typeListeners = this.listeners.computeIfAbsent(type, t -> new LinkedList());
        typeListeners.add(onType);
    }

    @Override
    public void fire(Event event) {
        Require.nonNull((String)"Event to send", (Object)event);
        this.pub.sendMore(event.getType().getName().getBytes(StandardCharsets.UTF_8));
        this.pub.sendMore(event.getId().toString().getBytes(StandardCharsets.UTF_8));
        this.pub.send(event.getRawData().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void close() {
        this.executor.shutdown();
        if (this.sub != null) {
            this.sub.close();
        }
        if (this.pub != null) {
            this.pub.close();
        }
    }
}

