/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.Port;
import org.openqa.selenium.internal.Require;

@Beta
public class ContainerInfo {
    private final Image image;
    private final Multimap<String, Map<String, Object>> portBindings;

    private ContainerInfo(Image image, Multimap<String, Map<String, Object>> portBindings) {
        this.image = (Image)Require.nonNull((String)"Container image", (Object)image);
        this.portBindings = (Multimap)Require.nonNull((String)"Port bindings", portBindings);
    }

    public static ContainerInfo image(Image image) {
        return new ContainerInfo(image, (Multimap<String, Map<String, Object>>)HashMultimap.create());
    }

    public ContainerInfo map(Port containerPort, Port hostPort) {
        Require.nonNull((String)"Container port", (Object)containerPort);
        Require.nonNull((String)"Host port", (Object)hostPort);
        if (!hostPort.getProtocol().equals(containerPort.getProtocol())) {
            throw new DockerException(String.format("Port protocols must match: %s -> %s", hostPort, containerPort));
        }
        HashMultimap updatedBindings = HashMultimap.create(this.portBindings);
        updatedBindings.put((Object)(containerPort.getPort() + "/" + containerPort.getProtocol()), (Object)ImmutableMap.of((Object)"HostPort", (Object)String.valueOf(hostPort.getPort()), (Object)"HostIp", (Object)""));
        return new ContainerInfo(this.image, (Multimap<String, Map<String, Object>>)updatedBindings);
    }

    public String toString() {
        return "ContainerInfo{image=" + this.image + ", portBindings=" + this.portBindings + '}';
    }

    private Map<String, Object> toJson() {
        ImmutableMap hostConfig = ImmutableMap.of((Object)"PortBindings", (Object)this.portBindings.asMap());
        return ImmutableMap.of((Object)"Image", (Object)this.image.getId(), (Object)"HostConfig", (Object)hostConfig);
    }
}

