/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router.httpd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import io.opentelemetry.trace.Tracer;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.grid.config.AnnotatedConfig;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.ConcatenatingConfig;
import org.openqa.selenium.grid.config.EnvConfig;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.config.DistributorFlags;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.server.BaseServerFlags;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.HelpFlags;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapFlags;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.HttpClient;

public class RouterServer
implements CliCommand {
    private static final Logger LOG = Logger.getLogger(RouterServer.class.getName());

    @Override
    public String getName() {
        return "router";
    }

    @Override
    public String getDescription() {
        return "Creates a router to front the selenium grid.";
    }

    @Override
    public CliCommand.Executable configure(String ... args) {
        HelpFlags help = new HelpFlags();
        BaseServerFlags serverFlags = new BaseServerFlags(4444);
        SessionMapFlags sessionMapFlags = new SessionMapFlags();
        DistributorFlags distributorFlags = new DistributorFlags();
        JCommander commander = JCommander.newBuilder().programName(this.getName()).addObject((Object)help).addObject((Object)serverFlags).addObject((Object)sessionMapFlags).addObject((Object)distributorFlags).build();
        return () -> {
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                System.err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, System.out)) {
                return;
            }
            CompoundConfig config = new CompoundConfig(new EnvConfig(), new ConcatenatingConfig("router", '.', System.getProperties()), new AnnotatedConfig(help), new AnnotatedConfig(serverFlags), new AnnotatedConfig(sessionMapFlags), new AnnotatedConfig(distributorFlags));
            LoggingOptions loggingOptions = new LoggingOptions(config);
            loggingOptions.configureLogging();
            Tracer tracer = loggingOptions.getTracer();
            NetworkOptions networkOptions = new NetworkOptions(config);
            HttpClient.Factory clientFactory = networkOptions.getHttpClientFactory(tracer);
            SessionMapOptions sessionsOptions = new SessionMapOptions(config);
            SessionMap sessions = sessionsOptions.getSessionMap();
            BaseServerOptions serverOptions = new BaseServerOptions(config);
            DistributorOptions distributorOptions = new DistributorOptions(config);
            Distributor distributor = distributorOptions.getDistributor(tracer, clientFactory);
            Router router = new Router(tracer, clientFactory, sessions, distributor);
            NettyServer server = new NettyServer(serverOptions, router);
            server.start();
            BuildInfo info = new BuildInfo();
            LOG.info(String.format("Started Selenium router %s (revision %s)", info.getReleaseLabel(), info.getBuildRevision()));
        };
    }
}

