/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.docker;

import com.google.common.collect.HashMultimap;
import io.opentelemetry.trace.Tracer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.docker.Docker;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.docker.DockerSessionFactory;
import org.openqa.selenium.grid.node.local.LocalNode;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;

public class DockerOptions {
    private static final Logger LOG = Logger.getLogger(DockerOptions.class.getName());
    private static final Json JSON = new Json();
    private final Config config;

    public DockerOptions(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    private URI getDockerUri() {
        try {
            Optional<String> possibleUri = this.config.get("docker", "url");
            if (possibleUri.isPresent()) {
                return new URI(possibleUri.get());
            }
            Optional<String> possibleHost = this.config.get("docker", "host");
            if (possibleHost.isPresent()) {
                String host = possibleHost.get();
                if (!(host.startsWith("tcp:") || host.startsWith("http:") || host.startsWith("https"))) {
                    host = "http://" + host;
                }
                URI uri = new URI(host);
                return new URI("http", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            }
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                return new URI("http://localhost:2376");
            }
            return new URI("unix:/var/run/docker.sock");
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Unable to determine docker url", new Object[]{e});
        }
    }

    private boolean isEnabled(HttpClient.Factory clientFactory) {
        if (!this.config.getAll("docker", "configs").isPresent()) {
            return false;
        }
        URI uri = this.getDockerUri();
        HttpClient client = clientFactory.createClient(ClientConfig.defaultConfig().baseUri(uri));
        return new Docker((HttpHandler)client).isSupported();
    }

    public void configure(Tracer tracer, HttpClient.Factory clientFactory, LocalNode.Builder node) throws IOException {
        if (!this.isEnabled(clientFactory)) {
            return;
        }
        List<String> allConfigs = this.config.getAll("docker", "configs").orElseThrow(() -> new DockerException("Unable to find docker configs"));
        HashMultimap kinds = HashMultimap.create();
        for (int i = 0; i < allConfigs.size(); ++i) {
            String imageName = allConfigs.get(i);
            if (++i == allConfigs.size()) {
                throw new DockerException("Unable to find JSON config");
            }
            Capabilities stereotype = (Capabilities)JSON.toType(allConfigs.get(i), Capabilities.class);
            kinds.put((Object)imageName, (Object)stereotype);
        }
        HttpClient client = clientFactory.createClient(ClientConfig.defaultConfig().baseUri(this.getDockerUri()));
        Docker docker = new Docker((HttpHandler)client);
        this.loadImages(docker, kinds.keySet().toArray(new String[0]));
        int maxContainerCount = Runtime.getRuntime().availableProcessors();
        kinds.forEach((name, caps) -> {
            Image image = docker.getImage((String)name);
            for (int i = 0; i < maxContainerCount; ++i) {
                node.add((Capabilities)caps, new DockerSessionFactory(tracer, clientFactory, docker, image, (Capabilities)caps));
            }
            LOG.info(String.format("Mapping %s to docker image %s %d times", caps, name, maxContainerCount));
        });
    }

    private void loadImages(Docker docker, String ... imageNames) {
        CompletableFuture<Void> cd = CompletableFuture.allOf((CompletableFuture[])Arrays.stream(imageNames).map(name -> CompletableFuture.supplyAsync(() -> docker.getImage((String)name))).toArray(CompletableFuture[]::new));
        try {
            cd.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

