/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.AnnotatedConfig;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.ConcatenatingConfig;
import org.openqa.selenium.grid.config.EnvConfig;
import org.openqa.selenium.grid.config.MapConfig;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.BaseServerFlags;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusFlags;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.HelpFlags;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Route;

public class MessageBusCommand
implements CliCommand {
    private static final Logger LOG = Logger.getLogger(MessageBusCommand.class.getName());

    @Override
    public String getName() {
        return "message-bus";
    }

    @Override
    public String getDescription() {
        return "Standalone instance of the message bus.";
    }

    @Override
    public boolean isShown() {
        return false;
    }

    @Override
    public CliCommand.Executable configure(String ... args) {
        HelpFlags help = new HelpFlags();
        BaseServerFlags baseFlags = new BaseServerFlags(5557);
        EventBusFlags eventBusFlags = new EventBusFlags();
        JCommander commander = JCommander.newBuilder().programName("standalone").addObject((Object)baseFlags).addObject((Object)eventBusFlags).addObject((Object)help).build();
        return () -> {
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                System.err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, System.out)) {
                return;
            }
            CompoundConfig config = new CompoundConfig(new EnvConfig(), new ConcatenatingConfig("message-bus", '.', System.getProperties()), new AnnotatedConfig(help), new AnnotatedConfig(eventBusFlags), new AnnotatedConfig(baseFlags), new MapConfig((Map<String, Object>)ImmutableMap.of((Object)"events", (Object)ImmutableMap.of((Object)"bind", (Object)true, (Object)"publish", (Object)"tcp://*:4442", (Object)"subscribe", (Object)"tcp://*:4443"))));
            LoggingOptions loggingOptions = new LoggingOptions(config);
            loggingOptions.configureLogging();
            EventBusOptions events = new EventBusOptions(config);
            EventBus bus = events.getEventBus();
            BaseServerOptions serverOptions = new BaseServerOptions(config);
            NettyServer server = new NettyServer(serverOptions, (HttpHandler)Route.get((String)"/status").to(() -> req -> (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", MediaType.JSON_UTF_8.toString())).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"ready", (Object)true, (Object)"message", (Object)"Event bus running")))));
            server.start();
            BuildInfo info = new BuildInfo();
            LOG.info(String.format("Started Selenium message bus %s (revision %s)", info.getReleaseLabel(), info.getBuildRevision()));
            Thread.currentThread().join();
            LOG.info("Shutting down: " + bus);
        };
    }
}

