/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_40;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.internal.ImageSummary;
import org.openqa.selenium.docker.internal.Reference;
import org.openqa.selenium.docker.v1_40.DockerMessages;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class ListImages {
    private static final Json JSON = new Json();
    private static final Type SET_OF_IMAGE_SUMMARIES = new TypeToken<Set<ImageSummary>>(){}.getType();
    private final HttpHandler client;

    public ListImages(HttpHandler client) {
        this.client = Objects.requireNonNull(client);
    }

    public Set<Image> apply(Reference reference) {
        Objects.requireNonNull(reference, "Reference to search for must be set");
        String familiarName = reference.getFamiliarName();
        ImmutableMap filters = ImmutableMap.of((Object)"reference", (Object)ImmutableMap.of((Object)familiarName, (Object)true));
        HttpRequest req = ((HttpRequest)((HttpRequest)new HttpRequest(HttpMethod.GET, "/v1.40/images/json").addHeader("Content-Length", "0")).addHeader("Content-Type", "application/json; charset=utf-8")).addQueryParameter("filters", JSON.toJson((Object)filters));
        HttpResponse response = DockerMessages.throwIfNecessary(this.client.execute(req), "Unable to list images for %s", reference);
        Set images = (Set)JSON.toType(Contents.string((HttpMessage)response), SET_OF_IMAGE_SUMMARIES);
        return (Set)images.stream().map(Image::new).collect(ImmutableSet.toImmutableSet());
    }
}

