/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Beta;
import org.openqa.selenium.docker.DockerException;

@Beta
public class Reference {
    private static final String DEFAULT_DOMAIN = "docker.io";
    private static final String DEFAULT_REPO = "library";
    private static final String DEFAULT_TAG = "latest";
    private static final String DOMAIN = "([\\w\\d-_.]+?(:(\\d+))?";
    private static final String REPO = "([\\w\\d-_.]+?)";
    private static final String NAME = "([\\w\\d-_.]+?)";
    private static final String TAG = "([\\w\\d-_.]+?)";
    private static final String DIGEST = "(sha256:[A-Fa-f0-9]{64})";
    private static final Map<Pattern, Function<Matcher, Reference>> PATTERNS = ImmutableMap.builder().put((Object)Pattern.compile("([\\w\\d-_.]+?)"), m -> new Reference(DEFAULT_DOMAIN, DEFAULT_REPO, m.group(1), DEFAULT_TAG, null)).put((Object)Pattern.compile(String.format("%s:%s", "([\\w\\d-_.]+?)", "([\\w\\d-_.]+?)")), m -> new Reference(DEFAULT_DOMAIN, DEFAULT_REPO, m.group(1), m.group(2), null)).put((Object)Pattern.compile(String.format("%s/%s", "([\\w\\d-_.]+?)", "([\\w\\d-_.]+?)")), m -> new Reference(DEFAULT_DOMAIN, m.group(1), m.group(2), DEFAULT_TAG, null)).put((Object)Pattern.compile(String.format("%s@%s", "([\\w\\d-_.]+?)", "(sha256:[A-Fa-f0-9]{64})")), m -> new Reference(DEFAULT_DOMAIN, DEFAULT_REPO, m.group(1), null, m.group(2))).put((Object)Pattern.compile(String.format("%s/%s:%s", "([\\w\\d-_.]+?)", "([\\w\\d-_.]+?)", "([\\w\\d-_.]+?)")), m -> new Reference(DEFAULT_DOMAIN, m.group(1), m.group(2), m.group(3), null)).put((Object)Pattern.compile(String.format("%s/%s@%s", "([\\w\\d-_.]+?)", "([\\w\\d-_.]+?)", "(sha256:[A-Fa-f0-9]{64})")), m -> new Reference(DEFAULT_DOMAIN, m.group(1), m.group(2), null, m.group(3))).build();
    private final String domain;
    private final String repository;
    private final String name;
    private final String tag;
    private final String digest;

    @VisibleForTesting
    Reference(String domain, String repository, String name, String tag, String digest) {
        this.domain = Objects.requireNonNull(domain);
        this.repository = Objects.requireNonNull(repository);
        this.name = Objects.requireNonNull(name);
        this.tag = tag;
        this.digest = digest;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getFamiliarName() {
        StringBuilder familiar = new StringBuilder();
        if (!DEFAULT_DOMAIN.equals(this.domain)) {
            familiar.append(this.domain).append("/");
        }
        if (!DEFAULT_REPO.equals(this.repository)) {
            familiar.append(this.repository).append("/");
        }
        familiar.append(this.name);
        if (this.digest != null) {
            familiar.append("@").append(this.digest);
        } else if (this.tag != null) {
            familiar.append(":").append(this.tag);
        } else {
            throw new DockerException("Unable to form familiar name: " + this);
        }
        return familiar.toString();
    }

    public static Reference parse(String input) {
        Objects.requireNonNull(input, "Reference to parse must be set.");
        for (Map.Entry<Pattern, Function<Matcher, Reference>> entry : PATTERNS.entrySet()) {
            Matcher matcher = entry.getKey().matcher(input);
            if (!matcher.matches()) continue;
            return entry.getValue().apply(matcher);
        }
        throw new DockerException("Unable to parse: " + input);
    }

    public String toString() {
        return "Reference{domain='" + this.domain + '\'' + ", repository='" + this.repository + '\'' + ", name='" + this.name + '\'' + ", tag='" + this.tag + '\'' + ", digest='" + this.digest + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference that = (Reference)o;
        return this.domain.equals(that.domain) && this.repository.equals(that.repository) && this.name.equals(that.name) && Objects.equals(this.tag, that.tag) && Objects.equals(this.digest, that.digest);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.repository, this.name, this.tag, this.digest);
    }
}

