/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Objects;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;

public class RoutableHttpClientFactory
implements HttpClient.Factory {
    private final URL self;
    private final CombinedHandler handler;
    private final HttpClient.Factory delegate;

    public RoutableHttpClientFactory(URL self, CombinedHandler handler, HttpClient.Factory delegate) {
        this.self = Objects.requireNonNull(self);
        this.handler = Objects.requireNonNull(handler);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public HttpClient createClient(ClientConfig config) {
        Objects.requireNonNull(config, "Client config to use must be set.");
        URL url = config.baseUrl();
        if (this.self.getProtocol().equals(url.getProtocol()) && this.self.getHost().equals(url.getHost()) && this.self.getPort() == url.getPort()) {
            return new HttpClient(){

                public HttpResponse execute(HttpRequest request) throws UncheckedIOException {
                    HttpResponse response = new HttpResponse();
                    if (!RoutableHttpClientFactory.this.handler.test(request)) {
                        response.setStatus(404);
                        response.setContent(Contents.utf8String((CharSequence)("Unable to route " + request)));
                        return response;
                    }
                    return RoutableHttpClientFactory.this.handler.execute(request);
                }

                public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
                    throw new UnsupportedOperationException("openSocket");
                }
            };
        }
        return this.delegate.createClient(config);
    }

    public void cleanupIdleClients() {
        this.delegate.cleanupIdleClients();
    }
}

