/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableSet;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;

public class ReverseProxyHandler
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger(ReverseProxyHandler.class.getName());
    private static final ImmutableSet<String> IGNORED_REQ_HEADERS = ImmutableSet.builder().add((Object)"connection").add((Object)"keep-alive").add((Object)"proxy-authorization").add((Object)"proxy-authenticate").add((Object)"proxy-connection").add((Object)"te").add((Object)"trailer").add((Object)"transfer-encoding").add((Object)"upgrade").build();
    private final Tracer tracer;
    private final HttpClient upstream;

    public ReverseProxyHandler(Tracer tracer, HttpClient httpClient) {
        this.tracer = Objects.requireNonNull(tracer, "Tracer must be set.");
        this.upstream = Objects.requireNonNull(httpClient, "HTTP client to use must be set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Span previous = this.tracer.scopeManager().activeSpan();
        SpanContext parent = HttpTracing.extract((Tracer)this.tracer, (HttpRequest)req);
        Span span = this.tracer.buildSpan("reverse_proxy").asChildOf(parent).start();
        try {
            this.tracer.scopeManager().activate(span);
            span.setTag((Tag)Tags.HTTP_METHOD, (Object)req.getMethod().toString());
            span.setTag((Tag)Tags.HTTP_URL, (Object)req.getUri());
            HttpRequest toUpstream = new HttpRequest(req.getMethod(), req.getUri());
            for (String name : req.getQueryParameterNames()) {
                for (String value : req.getQueryParameters(name)) {
                    toUpstream.addQueryParameter(name, value);
                }
            }
            for (String name : req.getHeaderNames()) {
                if (IGNORED_REQ_HEADERS.contains((Object)name.toLowerCase())) continue;
                for (String value : req.getHeaders(name)) {
                    toUpstream.addHeader(name, value);
                }
            }
            toUpstream.setHeader("Connection", "keep-alive");
            toUpstream.setContent(req.getContent());
            HttpResponse resp = this.upstream.execute(toUpstream);
            span.setTag((Tag)Tags.HTTP_STATUS, (Object)resp.getStatus());
            resp.removeHeader("Date");
            resp.removeHeader("Server");
            IGNORED_REQ_HEADERS.forEach(x$0 -> {
                HttpResponse cfr_ignored_0 = (HttpResponse)resp.removeHeader(x$0);
            });
            HttpResponse httpResponse = resp;
            return httpResponse;
        }
        finally {
            span.finish();
            this.tracer.scopeManager().activate(previous);
        }
    }
}

