/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.TracedCallable;

class HandleSession
implements HttpHandler {
    private final Tracer tracer;
    private final HttpClient.Factory httpClientFactory;
    private final SessionMap sessions;
    private final Cache<SessionId, HttpHandler> knownSessions;

    public HandleSession(Tracer tracer, HttpClient.Factory httpClientFactory, SessionMap sessions) {
        this.tracer = Objects.requireNonNull(tracer);
        this.httpClientFactory = Objects.requireNonNull(httpClientFactory);
        this.sessions = Objects.requireNonNull(sessions);
        this.knownSessions = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).build();
    }

    public HttpResponse execute(HttpRequest req) {
        Span previousSpan = this.tracer.scopeManager().activeSpan();
        SpanContext parent = HttpTracing.extract((Tracer)this.tracer, (HttpRequest)req);
        Span span = this.tracer.buildSpan("router.handle_session").asChildOf(parent).start();
        try {
            this.tracer.scopeManager().activate(span);
            span.setTag((Tag)Tags.HTTP_METHOD, (Object)req.getMethod().toString());
            span.setTag((Tag)Tags.HTTP_URL, (Object)req.getUri());
            SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> new NoSuchSessionException("Cannot find session: " + req));
            span.setTag("session.id", id.toString());
            try {
                HttpTracing.inject((Tracer)this.tracer, (Span)span, (HttpRequest)req);
                HttpResponse res = ((HttpHandler)this.knownSessions.get((Object)id, this.loadSessionId(this.tracer, span, id))).execute(req);
                span.setTag((Tag)Tags.HTTP_STATUS, (Object)res.getStatus());
                HttpResponse httpResponse = res;
                return httpResponse;
            }
            catch (ExecutionException e) {
                span.setTag((Tag)Tags.ERROR, (Object)true);
                span.setTag("error.message", e.getMessage());
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        finally {
            span.finish();
            this.tracer.scopeManager().activate(previousSpan);
        }
    }

    private Callable<HttpHandler> loadSessionId(Tracer tracer, Span span, SessionId id) {
        return new TracedCallable(tracer, span, () -> {
            Session session = this.sessions.get(id);
            if (session instanceof HttpHandler) {
                return (HttpHandler)session;
            }
            HttpClient client = this.httpClientFactory.createClient(Urls.fromUri((URI)session.getUri()));
            return new ReverseProxyHandler(tracer, client);
        });
    }
}

