/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class HandleSession
implements HttpHandler {
    private final LoadingCache<SessionId, HttpHandler> knownSessions;

    public HandleSession(final HttpClient.Factory httpClientFactory, final SessionMap sessions) {
        Objects.requireNonNull(sessions);
        this.knownSessions = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).build((CacheLoader)new CacheLoader<SessionId, HttpHandler>(){

            public HttpHandler load(SessionId id) {
                Session session = sessions.get(id);
                if (session instanceof HttpHandler) {
                    return (HttpHandler)session;
                }
                HttpClient client = httpClientFactory.createClient(Urls.fromUri((URI)session.getUri()));
                return new ReverseProxyHandler(client);
            }
        });
    }

    public HttpResponse execute(HttpRequest req) {
        SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> new NoSuchSessionException("Cannot find session: " + req));
        try {
            return ((HttpHandler)this.knownSessions.get((Object)id)).execute(req);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

