/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class GridStatusHandler
implements HttpHandler {
    private static final ScheduledExecutorService SCHEDULED_SERVICE = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r, "Scheduled grid status executor");
        thread.setDaemon(true);
        return thread;
    });
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r, "Grid status executor");
        thread.setDaemon(true);
        return thread;
    });
    private final Json json;
    private final HttpClient.Factory clientFactory;
    private final Distributor distributor;

    public GridStatusHandler(Json json, HttpClient.Factory clientFactory, Distributor distributor) {
        this.json = Objects.requireNonNull(json, "JSON encoder must be set.");
        this.clientFactory = Objects.requireNonNull(clientFactory, "HTTP client factory must be set.");
        this.distributor = Objects.requireNonNull(distributor, "Distributor must be set.");
    }

    public HttpResponse execute(HttpRequest req) {
        DistributorStatus status;
        long start = System.currentTimeMillis();
        try {
            status = EXECUTOR_SERVICE.submit(this.distributor::getStatus).get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return (HttpResponse)new HttpResponse().setContent(Contents.utf8String((CharSequence)this.json.toJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"ready", (Object)false, (Object)"message", (Object)"Unable to read distributor status.")))));
        }
        boolean ready = status.hasCapacity();
        String message = ready ? "Selenium Grid ready." : "Selenium Grid not ready.";
        long remaining = System.currentTimeMillis() + 2000L - start;
        List nodeResults = status.getNodes().stream().map(summary -> {
            ImmutableMap defaultResponse = ImmutableMap.of((Object)"id", (Object)summary.getNodeId(), (Object)"uri", (Object)summary.getUri(), (Object)"maxSessions", (Object)summary.getMaxSessionCount(), (Object)"stereotypes", summary.getStereotypes(), (Object)"warning", (Object)"Unable to read data from node.");
            CompletableFuture toReturn = new CompletableFuture();
            Future<?> future = EXECUTOR_SERVICE.submit(() -> {
                try {
                    HttpClient client = this.clientFactory.createClient(summary.getUri().toURL());
                    HttpResponse res = client.execute(new HttpRequest(HttpMethod.GET, "/se/grid/node/status"));
                    if (res.getStatus() == 200) {
                        toReturn.complete((Map)this.json.toType(Contents.string((HttpMessage)res), Json.MAP_TYPE));
                    } else {
                        toReturn.complete(defaultResponse);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    toReturn.complete(defaultResponse);
                }
            });
            SCHEDULED_SERVICE.schedule(() -> {
                if (!toReturn.isDone()) {
                    toReturn.complete(defaultResponse);
                    future.cancel(true);
                }
            }, remaining, TimeUnit.MILLISECONDS);
            return toReturn;
        }).collect(Collectors.toList());
        ImmutableMap.Builder value = ImmutableMap.builder();
        value.put((Object)"ready", (Object)ready);
        value.put((Object)"message", (Object)message);
        value.put((Object)"nodes", nodeResults.stream().map(summary -> {
            try {
                return (Map)summary.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw this.wrap(e);
            }
        }).collect(Collectors.toList()));
        return (HttpResponse)new HttpResponse().setContent(Contents.utf8String((CharSequence)this.json.toJson((Object)ImmutableMap.of((Object)"value", (Object)value.build()))));
    }

    private RuntimeException wrap(Exception e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return new RuntimeException(e);
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        return cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
    }
}

