/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.xpi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.ClasspathExtension;
import org.openqa.selenium.firefox.Extension;
import org.openqa.selenium.firefox.FileExtension;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;

public class XpiDriverService
extends FirefoxDriverService {
    private static final String NO_FOCUS_LIBRARY_NAME = "x_ignore_nofocus.so";
    private static final String PATH_PREFIX = "/" + XpiDriverService.class.getPackage().getName().replace(".", "/") + "/";
    private final Lock lock = new ReentrantLock();
    private final int port;
    private final FirefoxBinary binary;
    private final FirefoxProfile profile;
    private File profileDir;

    private XpiDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment, FirefoxBinary binary, FirefoxProfile profile, File logFile) throws IOException {
        super(executable, port, args, environment);
        Preconditions.checkState((port > 0 ? 1 : 0) != 0, (Object)"Port must be set");
        this.port = port;
        this.binary = binary;
        this.profile = profile;
        String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
        if (firefoxLogFile != null) {
            if ("/dev/stdout".equals(firefoxLogFile)) {
                this.sendOutputTo(System.out);
            } else if ("/dev/stderr".equals(firefoxLogFile)) {
                this.sendOutputTo(System.err);
            } else if ("/dev/null".equals(firefoxLogFile)) {
                this.sendOutputTo(ByteStreams.nullOutputStream());
            } else {
                this.sendOutputTo(new FileOutputStream(firefoxLogFile));
            }
        } else if (logFile != null) {
            this.sendOutputTo(new FileOutputStream(logFile));
        } else {
            this.sendOutputTo(ByteStreams.nullOutputStream());
        }
    }

    protected URL getUrl(int port) throws MalformedURLException {
        return new URL("http", "localhost", port, "/hub");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.lock.lock();
        try {
            this.profile.setPreference("webdriver_firefox_port", this.port);
            this.addWebDriverExtension(this.profile);
            this.profileDir = this.profile.layoutOnDisk();
            ImmutableMap.Builder envBuilder = new ImmutableMap.Builder().putAll(this.getEnvironment()).put((Object)"XRE_PROFILE_PATH", (Object)this.profileDir.getAbsolutePath()).put((Object)"MOZ_NO_REMOTE", (Object)"1").put((Object)"MOZ_CRASHREPORTER_DISABLE", (Object)"1").put((Object)"NO_EM_RESTART", (Object)"1");
            if (Platform.getCurrent().is(Platform.LINUX) && this.profile.shouldLoadNoFocusLib()) {
                this.modifyLinkLibraryPath((ImmutableMap.Builder<String, String>)envBuilder, this.profileDir);
            }
            ImmutableMap env = envBuilder.build();
            ArrayList<String> cmdArray = new ArrayList<String>(this.getArgs());
            cmdArray.addAll(this.binary.getExtraOptions());
            cmdArray.add("-foreground");
            this.process = new CommandLine(this.binary.getPath(), (String[])Iterables.toArray(cmdArray, String.class));
            this.process.setEnvironmentVariables((Map)env);
            this.process.updateDynamicLibraryPath((String)env.get(CommandLine.getLibraryPathPropertyName()));
            if (!Platform.getCurrent().is(Platform.MAC) || Platform.getCurrent().getMinorVersion() <= 5) {
                String firefoxLibraryPath = System.getProperty("webdriver.firefox.library.path", this.binary.getFile().getAbsoluteFile().getParentFile().getAbsolutePath());
                this.process.updateDynamicLibraryPath(firefoxLibraryPath);
            }
            this.process.copyOutputTo(this.getOutputStream());
            this.process.executeAsync();
            this.waitUntilAvailable();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void modifyLinkLibraryPath(ImmutableMap.Builder<String, String> envBuilder, File profileDir) {
        String existingLdLibPath = System.getenv("LD_LIBRARY_PATH");
        String newLdLibPath = this.extractAndCheck(profileDir, NO_FOCUS_LIBRARY_NAME, PATH_PREFIX + "x86", PATH_PREFIX + "amd64");
        if (existingLdLibPath != null && !existingLdLibPath.equals("")) {
            newLdLibPath = newLdLibPath + existingLdLibPath;
        }
        envBuilder.put((Object)"LD_LIBRARY_PATH", (Object)newLdLibPath);
        envBuilder.put((Object)"LD_PRELOAD", (Object)NO_FOCUS_LIBRARY_NAME);
    }

    private String extractAndCheck(File profileDir, String noFocusSoName, String jarPath32Bit, String jarPath64Bit) {
        HashSet<String> pathsSet = new HashSet<String>();
        pathsSet.add(jarPath32Bit);
        pathsSet.add(jarPath64Bit);
        StringBuilder builtPath = new StringBuilder();
        for (String path : pathsSet) {
            try {
                FileHandler.copyResource((File)profileDir, ((Object)((Object)this)).getClass(), (String[])new String[]{path + File.separator + noFocusSoName});
            }
            catch (IOException e) {
                if (Boolean.getBoolean("webdriver.development")) {
                    System.err.println("Exception unpacking required library, but in development mode. Continuing");
                }
                throw new WebDriverException((Throwable)e);
            }
            String outSoPath = profileDir.getAbsolutePath() + File.separator + path;
            File file = new File(outSoPath, noFocusSoName);
            if (!file.exists()) {
                throw new WebDriverException("Could not locate " + path + ": native events will not work.");
            }
            builtPath.append(outSoPath).append(":");
        }
        return builtPath.toString();
    }

    protected void waitUntilAvailable() throws MalformedURLException {
        try {
            URL status = new URL(this.getUrl(this.port).toString() + "/status");
            new UrlChecker().waitUntilAvailable(45L, TimeUnit.SECONDS, new URL[]{status});
        }
        catch (UrlChecker.TimeoutException e) {
            throw new WebDriverException("Timed out waiting 45 seconds for Firefox to start.", (Throwable)e);
        }
    }

    public void stop() {
        super.stop();
        this.profile.cleanTemporaryModel();
        this.profile.clean(this.profileDir);
    }

    private void addWebDriverExtension(FirefoxProfile profile) {
        if (profile.containsWebDriverExtension()) {
            return;
        }
        profile.addExtension("webdriver", this.loadCustomExtension().orElse(XpiDriverService.loadDefaultExtension()));
    }

    private Optional<Extension> loadCustomExtension() {
        String xpiProperty = System.getProperty("webdriver.firefox.driver");
        if (xpiProperty != null) {
            File xpi = new File(xpiProperty);
            return Optional.of(new FileExtension(xpi));
        }
        return Optional.empty();
    }

    private static Extension loadDefaultExtension() {
        return new ClasspathExtension(FirefoxProfile.class, "/" + XpiDriverService.class.getPackage().getName().replace(".", "/") + "/webdriver.xpi");
    }

    public static XpiDriverService createDefaultService() {
        try {
            return (XpiDriverService)new Builder().build();
        }
        catch (WebDriverException e) {
            throw new IllegalStateException(e.getMessage(), e.getCause());
        }
    }

    static XpiDriverService createDefaultService(Capabilities caps) {
        Builder builder = (Builder)new Builder().usingAnyFreePort();
        Stream.of(() -> (FirefoxProfile)caps.getCapability("firefox_profile"), () -> {
            try {
                return FirefoxProfile.fromJson((String)((String)caps.getCapability("firefox_profile")));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }, () -> ((FirefoxOptions)caps).getProfile(), () -> (FirefoxProfile)((Map)caps.getCapability("moz:firefoxOptions")).get("profile"), () -> {
            try {
                return FirefoxProfile.fromJson((String)((String)((Map)caps.getCapability("moz:firefoxOptions")).get("profile")));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }, () -> {
            Map options = (Map)caps.getCapability("moz:firefoxOptions");
            FirefoxProfile toReturn = new FirefoxProfile();
            ((Map)options.get("prefs")).forEach((key, value) -> {
                if (value instanceof Boolean) {
                    toReturn.setPreference(key, ((Boolean)value).booleanValue());
                }
                if (value instanceof Integer) {
                    toReturn.setPreference(key, ((Integer)value).intValue());
                }
                if (value instanceof String) {
                    toReturn.setPreference(key, (String)value);
                }
            });
            return toReturn;
        }).map(supplier -> {
            try {
                return (FirefoxProfile)supplier.get();
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().ifPresent(builder::withProfile);
        Object binary = caps.getCapability("firefox_binary");
        if (binary != null) {
            FirefoxBinary actualBinary;
            if (binary instanceof FirefoxBinary) {
                actualBinary = (FirefoxBinary)binary;
            } else if (binary instanceof String) {
                actualBinary = new FirefoxBinary(new File(String.valueOf(binary)));
            } else {
                throw new IllegalArgumentException("Expected binary to be a string or a binary: " + binary);
            }
            builder.withBinary(actualBinary);
        }
        return (XpiDriverService)builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends FirefoxDriverService.Builder<XpiDriverService, Builder> {
        private FirefoxBinary binary = null;
        private FirefoxProfile profile = null;

        protected boolean isLegacy() {
            return true;
        }

        public int score(Capabilities capabilities) {
            if (capabilities.is("marionette")) {
                return 0;
            }
            int score = 0;
            if (capabilities.getCapability("firefox_binary") != null) {
                ++score;
            }
            if (capabilities.getCapability("firefox_profile") != null) {
                ++score;
            }
            return score;
        }

        public Builder withBinary(FirefoxBinary binary) {
            this.binary = (FirefoxBinary)Preconditions.checkNotNull((Object)binary);
            return this;
        }

        public Builder withProfile(FirefoxProfile profile) {
            this.profile = (FirefoxProfile)Preconditions.checkNotNull((Object)profile);
            return this;
        }

        protected FirefoxDriverService.Builder withOptions(FirefoxOptions options) {
            FirefoxProfile profile = options.getProfile();
            if (profile == null) {
                profile = new FirefoxProfile();
                options.setCapability("firefox_profile", (Object)profile);
            }
            this.withBinary(options.getBinary());
            this.withProfile(profile);
            return this;
        }

        protected File findDefaultExecutable() {
            if (this.binary == null) {
                return new FirefoxBinary().getFile();
            }
            return this.binary.getFile();
        }

        protected ImmutableList<String> createArgs() {
            return ImmutableList.of((Object)"-foreground");
        }

        protected XpiDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new XpiDriverService(exe, port, args, environment, this.binary == null ? new FirefoxBinary() : this.binary, this.profile == null ? new FirefoxProfile() : this.profile, this.getLogFile());
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

