/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.internal.FileHandler;
import org.openqa.selenium.internal.TemporaryFilesystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilesIni {
    private Map<String, FirefoxProfile> profiles = new HashMap<String, FirefoxProfile>();

    public ProfilesIni() {
        File appData = this.locateAppDataDirectory(Platform.getCurrent());
        this.profiles = this.readProfiles(appData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, FirefoxProfile> readProfiles(File appData) {
        HashMap<String, FirefoxProfile> toReturn = new HashMap<String, FirefoxProfile>();
        File profilesIni = new File(appData, "profiles.ini");
        if (!profilesIni.exists()) {
            return toReturn;
        }
        boolean isRelative = true;
        String name = null;
        String path = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(profilesIni));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("[Profile")) {
                    FirefoxProfile profile = this.newProfile(name, appData, path, isRelative);
                    if (profile != null) {
                        toReturn.put(name, profile);
                    }
                    name = null;
                    path = null;
                } else if (line.startsWith("Name=")) {
                    name = line.substring("Name=".length());
                } else if (line.startsWith("IsRelative=")) {
                    isRelative = line.endsWith("1");
                } else if (line.startsWith("Path=")) {
                    path = line.substring("Path=".length());
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            try {
                throw new WebDriverException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (reader == null) throw throwable;
                    FirefoxProfile profile = this.newProfile(name, appData, path, isRelative);
                    if (profile != null) {
                        toReturn.put(name, profile);
                    }
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (reader == null) return toReturn;
            FirefoxProfile profile = this.newProfile(name, appData, path, isRelative);
            if (profile != null) {
                toReturn.put(name, profile);
            }
            reader.close();
            return toReturn;
        }
        catch (IOException e) {
            return toReturn;
        }
    }

    protected FirefoxProfile newProfile(String name, File appData, String path, boolean isRelative) {
        if (name != null && path != null) {
            File profileDir = isRelative ? new File(appData, path) : new File(path);
            return new ProfileFromDirectory(profileDir);
        }
        return null;
    }

    public FirefoxProfile getProfile(String profileName) {
        FirefoxProfile liveProfile = this.profiles.get(profileName);
        if (liveProfile == null) {
            return null;
        }
        File tempDir = TemporaryFilesystem.createTempDir((String)"userprofile", (String)"copy");
        try {
            FileHandler.copy((File)liveProfile.getProfileDir(), (File)tempDir);
            File compreg = new File(tempDir, "compreg.dat");
            if (compreg.exists() && !compreg.delete()) {
                throw new WebDriverException("Cannot delete file from copy of profile " + profileName);
            }
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        ProfileFromDirectory profile = new ProfileFromDirectory(tempDir);
        if (profile.getPort() == 0) {
            profile.setPort(7055);
        }
        return profile;
    }

    public Collection<FirefoxProfile> getExistingProfiles() {
        return this.profiles.values();
    }

    protected File locateAppDataDirectory(Platform os) {
        File appData;
        switch (os) {
            case WINDOWS: 
            case VISTA: 
            case XP: {
                appData = new File(MessageFormat.format("{0}\\Mozilla\\Firefox", System.getenv("APPDATA")));
                break;
            }
            case MAC: {
                appData = new File(MessageFormat.format("{0}/Library/Application Support/Firefox", System.getenv("HOME")));
                break;
            }
            default: {
                appData = new File(MessageFormat.format("{0}/.mozilla/firefox", System.getenv("HOME")));
            }
        }
        if (!appData.exists()) {
            return null;
        }
        if (!appData.isDirectory()) {
            throw new WebDriverException("The discovered user firefox data directory (which normally contains the profiles) isn't a directory: " + appData.getAbsolutePath());
        }
        return appData;
    }

    private static class ProfileFromDirectory
    extends FirefoxProfile {
        public ProfileFromDirectory(File dir) {
            super(dir);
        }
    }
}

