/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.serviceworker.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.serviceworker.model.RegistrationID;
import org.openqa.selenium.devtools.serviceworker.model.ServiceWorkerVersionRunningStatus;
import org.openqa.selenium.devtools.serviceworker.model.ServiceWorkerVersionStatus;
import org.openqa.selenium.devtools.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class ServiceWorkerVersion {
    private final String versionId;
    private final RegistrationID registrationId;
    private final String scriptURL;
    private final ServiceWorkerVersionRunningStatus runningStatus;
    private final ServiceWorkerVersionStatus status;
    private final Number scriptLastModified;
    private final Number scriptResponseTime;
    private final List<TargetID> controlledClients;
    private final TargetID targetId;

    public ServiceWorkerVersion(String versionId, RegistrationID registrationId, String scriptURL, ServiceWorkerVersionRunningStatus runningStatus, ServiceWorkerVersionStatus status, Number scriptLastModified, Number scriptResponseTime, List<TargetID> controlledClients, TargetID targetId) {
        this.versionId = Objects.requireNonNull(versionId, "versionId is required");
        this.registrationId = Objects.requireNonNull(registrationId, "registrationId is required");
        this.scriptURL = Objects.requireNonNull(scriptURL, "scriptURL is required");
        this.runningStatus = Objects.requireNonNull(runningStatus, "runningStatus is required");
        this.status = Objects.requireNonNull(status, "status is required");
        this.scriptLastModified = scriptLastModified;
        this.scriptResponseTime = scriptResponseTime;
        this.controlledClients = controlledClients;
        this.targetId = targetId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public RegistrationID getRegistrationId() {
        return this.registrationId;
    }

    public String getScriptURL() {
        return this.scriptURL;
    }

    public ServiceWorkerVersionRunningStatus getRunningStatus() {
        return this.runningStatus;
    }

    public ServiceWorkerVersionStatus getStatus() {
        return this.status;
    }

    public Number getScriptLastModified() {
        return this.scriptLastModified;
    }

    public Number getScriptResponseTime() {
        return this.scriptResponseTime;
    }

    public List<TargetID> getControlledClients() {
        return this.controlledClients;
    }

    public TargetID getTargetId() {
        return this.targetId;
    }

    private static ServiceWorkerVersion fromJson(JsonInput input) {
        String versionId = null;
        RegistrationID registrationId = null;
        String scriptURL = null;
        ServiceWorkerVersionRunningStatus runningStatus = null;
        ServiceWorkerVersionStatus status = null;
        Number scriptLastModified = null;
        Number scriptResponseTime = null;
        List controlledClients = null;
        TargetID targetId = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "versionId": {
                    versionId = input.nextString();
                    continue block22;
                }
                case "registrationId": {
                    registrationId = (RegistrationID)input.read(RegistrationID.class);
                    continue block22;
                }
                case "scriptURL": {
                    scriptURL = input.nextString();
                    continue block22;
                }
                case "runningStatus": {
                    runningStatus = (ServiceWorkerVersionRunningStatus)((Object)input.read(ServiceWorkerVersionRunningStatus.class));
                    continue block22;
                }
                case "status": {
                    status = (ServiceWorkerVersionStatus)((Object)input.read(ServiceWorkerVersionStatus.class));
                    continue block22;
                }
                case "scriptLastModified": {
                    scriptLastModified = input.nextNumber();
                    continue block22;
                }
                case "scriptResponseTime": {
                    scriptResponseTime = input.nextNumber();
                    continue block22;
                }
                case "controlledClients": {
                    controlledClients = (List)input.read(new TypeToken<List<TargetID>>(){}.getType());
                    continue block22;
                }
                case "targetId": {
                    targetId = (TargetID)input.read(TargetID.class);
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ServiceWorkerVersion(versionId, registrationId, scriptURL, runningStatus, status, scriptLastModified, scriptResponseTime, controlledClients, targetId);
    }
}

