/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.Headers;
import org.openqa.selenium.devtools.network.model.ResourceTiming;
import org.openqa.selenium.devtools.network.model.SecurityDetails;
import org.openqa.selenium.devtools.security.model.SecurityState;
import org.openqa.selenium.json.JsonInput;

public class Response {
    private final String url;
    private final Integer status;
    private final String statusText;
    private final Headers headers;
    private final String headersText;
    private final String mimeType;
    private final Headers requestHeaders;
    private final String requestHeadersText;
    private final Boolean connectionReused;
    private final Number connectionId;
    private final String remoteIPAddress;
    private final Integer remotePort;
    private final Boolean fromDiskCache;
    private final Boolean fromServiceWorker;
    private final Boolean fromPrefetchCache;
    private final Number encodedDataLength;
    private final ResourceTiming timing;
    private final String protocol;
    private final SecurityState securityState;
    private final SecurityDetails securityDetails;

    public Response(String url, Integer status, String statusText, Headers headers, String headersText, String mimeType, Headers requestHeaders, String requestHeadersText, Boolean connectionReused, Number connectionId, String remoteIPAddress, Integer remotePort, Boolean fromDiskCache, Boolean fromServiceWorker, Boolean fromPrefetchCache, Number encodedDataLength, ResourceTiming timing, String protocol, SecurityState securityState, SecurityDetails securityDetails) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.status = Objects.requireNonNull(status, "status is required");
        this.statusText = Objects.requireNonNull(statusText, "statusText is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.headersText = headersText;
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType is required");
        this.requestHeaders = requestHeaders;
        this.requestHeadersText = requestHeadersText;
        this.connectionReused = Objects.requireNonNull(connectionReused, "connectionReused is required");
        this.connectionId = Objects.requireNonNull(connectionId, "connectionId is required");
        this.remoteIPAddress = remoteIPAddress;
        this.remotePort = remotePort;
        this.fromDiskCache = fromDiskCache;
        this.fromServiceWorker = fromServiceWorker;
        this.fromPrefetchCache = fromPrefetchCache;
        this.encodedDataLength = Objects.requireNonNull(encodedDataLength, "encodedDataLength is required");
        this.timing = timing;
        this.protocol = protocol;
        this.securityState = Objects.requireNonNull(securityState, "securityState is required");
        this.securityDetails = securityDetails;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getHeadersText() {
        return this.headersText;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Headers getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestHeadersText() {
        return this.requestHeadersText;
    }

    public Boolean getConnectionReused() {
        return this.connectionReused;
    }

    public Number getConnectionId() {
        return this.connectionId;
    }

    public String getRemoteIPAddress() {
        return this.remoteIPAddress;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public Boolean getFromDiskCache() {
        return this.fromDiskCache;
    }

    public Boolean getFromServiceWorker() {
        return this.fromServiceWorker;
    }

    public Boolean getFromPrefetchCache() {
        return this.fromPrefetchCache;
    }

    public Number getEncodedDataLength() {
        return this.encodedDataLength;
    }

    public ResourceTiming getTiming() {
        return this.timing;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public SecurityState getSecurityState() {
        return this.securityState;
    }

    public SecurityDetails getSecurityDetails() {
        return this.securityDetails;
    }

    private static Response fromJson(JsonInput input) {
        String url = null;
        Integer status = null;
        String statusText = null;
        Headers headers = null;
        String headersText = null;
        String mimeType = null;
        Headers requestHeaders = null;
        String requestHeadersText = null;
        Boolean connectionReused = null;
        Number connectionId = null;
        String remoteIPAddress = null;
        Integer remotePort = null;
        Boolean fromDiskCache = null;
        Boolean fromServiceWorker = null;
        Boolean fromPrefetchCache = null;
        Number encodedDataLength = null;
        ResourceTiming timing = null;
        String protocol = null;
        SecurityState securityState = null;
        SecurityDetails securityDetails = null;
        input.beginObject();
        block44: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block44;
                }
                case "status": {
                    status = input.nextNumber().intValue();
                    continue block44;
                }
                case "statusText": {
                    statusText = input.nextString();
                    continue block44;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block44;
                }
                case "headersText": {
                    headersText = input.nextString();
                    continue block44;
                }
                case "mimeType": {
                    mimeType = input.nextString();
                    continue block44;
                }
                case "requestHeaders": {
                    requestHeaders = (Headers)((Object)input.read(Headers.class));
                    continue block44;
                }
                case "requestHeadersText": {
                    requestHeadersText = input.nextString();
                    continue block44;
                }
                case "connectionReused": {
                    connectionReused = input.nextBoolean();
                    continue block44;
                }
                case "connectionId": {
                    connectionId = input.nextNumber();
                    continue block44;
                }
                case "remoteIPAddress": {
                    remoteIPAddress = input.nextString();
                    continue block44;
                }
                case "remotePort": {
                    remotePort = input.nextNumber().intValue();
                    continue block44;
                }
                case "fromDiskCache": {
                    fromDiskCache = input.nextBoolean();
                    continue block44;
                }
                case "fromServiceWorker": {
                    fromServiceWorker = input.nextBoolean();
                    continue block44;
                }
                case "fromPrefetchCache": {
                    fromPrefetchCache = input.nextBoolean();
                    continue block44;
                }
                case "encodedDataLength": {
                    encodedDataLength = input.nextNumber();
                    continue block44;
                }
                case "timing": {
                    timing = (ResourceTiming)input.read(ResourceTiming.class);
                    continue block44;
                }
                case "protocol": {
                    protocol = input.nextString();
                    continue block44;
                }
                case "securityState": {
                    securityState = (SecurityState)((Object)input.read(SecurityState.class));
                    continue block44;
                }
                case "securityDetails": {
                    securityDetails = (SecurityDetails)input.read(SecurityDetails.class);
                    continue block44;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Response(url, status, statusText, headers, headersText, mimeType, requestHeaders, requestHeadersText, connectionReused, connectionId, remoteIPAddress, remotePort, fromDiskCache, fromServiceWorker, fromPrefetchCache, encodedDataLength, timing, protocol, securityState, securityDetails);
    }
}

