/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.headlessexperimental;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.headlessexperimental.model.ScreenshotParams;
import org.openqa.selenium.json.JsonInput;

@Beta
public class HeadlessExperimental {
    public static Command<BeginFrameResponse> beginFrame(Optional<Number> frameTimeTicks, Optional<Number> interval, Optional<Boolean> noDisplayUpdates, Optional<ScreenshotParams> screenshot) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        frameTimeTicks.ifPresent(p -> params.put((Object)"frameTimeTicks", p));
        interval.ifPresent(p -> params.put((Object)"interval", p));
        noDisplayUpdates.ifPresent(p -> params.put((Object)"noDisplayUpdates", p));
        screenshot.ifPresent(p -> params.put((Object)"screenshot", p));
        return new Command<BeginFrameResponse>("HeadlessExperimental.beginFrame", (Map<String, Object>)params.build(), input -> (BeginFrameResponse)input.read(BeginFrameResponse.class));
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("HeadlessExperimental.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("HeadlessExperimental.enable", (Map<String, Object>)params.build());
    }

    public static Event<Boolean> needsBeginFramesChanged() {
        return new Event<Boolean>("HeadlessExperimental.needsBeginFramesChanged", ConverterFunctions.map("needsBeginFrames", Boolean.class));
    }

    public static class BeginFrameResponse {
        private final Boolean hasDamage;
        private final String screenshotData;

        public BeginFrameResponse(Boolean hasDamage, String screenshotData) {
            this.hasDamage = Objects.requireNonNull(hasDamage, "hasDamage is required");
            this.screenshotData = Objects.requireNonNull(screenshotData, "screenshotData is required");
        }

        public Boolean getHasDamage() {
            return this.hasDamage;
        }

        public String getScreenshotData() {
            return this.screenshotData;
        }

        private static BeginFrameResponse fromJson(JsonInput input) {
            Boolean hasDamage = null;
            String screenshotData = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "hasDamage": {
                        hasDamage = input.nextBoolean();
                        continue block8;
                    }
                    case "screenshotData": {
                        screenshotData = input.nextString();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new BeginFrameResponse(hasDamage, screenshotData);
        }
    }
}

