/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.debugger.model;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.runtime.model.ScriptId;
import org.openqa.selenium.devtools.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class ScriptParsed {
    private final ScriptId scriptId;
    private final String url;
    private final Integer startLine;
    private final Integer startColumn;
    private final Integer endLine;
    private final Integer endColumn;
    private final ExecutionContextId executionContextId;
    private final String hash;
    private final Map<String, Object> executionContextAuxData;
    private final Boolean isLiveEdit;
    private final String sourceMapURL;
    private final Boolean hasSourceURL;
    private final Boolean isModule;
    private final Integer length;
    private final StackTrace stackTrace;

    public ScriptParsed(ScriptId scriptId, String url, Integer startLine, Integer startColumn, Integer endLine, Integer endColumn, ExecutionContextId executionContextId, String hash, Map<String, Object> executionContextAuxData, Boolean isLiveEdit, String sourceMapURL, Boolean hasSourceURL, Boolean isModule, Integer length, StackTrace stackTrace) {
        this.scriptId = Objects.requireNonNull(scriptId, "scriptId is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.startLine = Objects.requireNonNull(startLine, "startLine is required");
        this.startColumn = Objects.requireNonNull(startColumn, "startColumn is required");
        this.endLine = Objects.requireNonNull(endLine, "endLine is required");
        this.endColumn = Objects.requireNonNull(endColumn, "endColumn is required");
        this.executionContextId = Objects.requireNonNull(executionContextId, "executionContextId is required");
        this.hash = Objects.requireNonNull(hash, "hash is required");
        this.executionContextAuxData = executionContextAuxData;
        this.isLiveEdit = isLiveEdit;
        this.sourceMapURL = sourceMapURL;
        this.hasSourceURL = hasSourceURL;
        this.isModule = isModule;
        this.length = length;
        this.stackTrace = stackTrace;
    }

    public ScriptId getScriptId() {
        return this.scriptId;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getStartLine() {
        return this.startLine;
    }

    public Integer getStartColumn() {
        return this.startColumn;
    }

    public Integer getEndLine() {
        return this.endLine;
    }

    public Integer getEndColumn() {
        return this.endColumn;
    }

    public ExecutionContextId getExecutionContextId() {
        return this.executionContextId;
    }

    public String getHash() {
        return this.hash;
    }

    public Map<String, Object> getExecutionContextAuxData() {
        return this.executionContextAuxData;
    }

    @Beta
    public Boolean getIsLiveEdit() {
        return this.isLiveEdit;
    }

    public String getSourceMapURL() {
        return this.sourceMapURL;
    }

    public Boolean getHasSourceURL() {
        return this.hasSourceURL;
    }

    public Boolean getIsModule() {
        return this.isModule;
    }

    public Integer getLength() {
        return this.length;
    }

    @Beta
    public StackTrace getStackTrace() {
        return this.stackTrace;
    }

    private static ScriptParsed fromJson(JsonInput input) {
        ScriptId scriptId = null;
        String url = null;
        Integer startLine = null;
        Integer startColumn = null;
        Integer endLine = null;
        Integer endColumn = null;
        ExecutionContextId executionContextId = null;
        String hash = null;
        Map executionContextAuxData = null;
        Boolean isLiveEdit = null;
        String sourceMapURL = null;
        Boolean hasSourceURL = null;
        Boolean isModule = null;
        Integer length = null;
        StackTrace stackTrace = null;
        input.beginObject();
        block34: while (input.hasNext()) {
            switch (input.nextName()) {
                case "scriptId": {
                    scriptId = (ScriptId)input.read(ScriptId.class);
                    continue block34;
                }
                case "url": {
                    url = input.nextString();
                    continue block34;
                }
                case "startLine": {
                    startLine = input.nextNumber().intValue();
                    continue block34;
                }
                case "startColumn": {
                    startColumn = input.nextNumber().intValue();
                    continue block34;
                }
                case "endLine": {
                    endLine = input.nextNumber().intValue();
                    continue block34;
                }
                case "endColumn": {
                    endColumn = input.nextNumber().intValue();
                    continue block34;
                }
                case "executionContextId": {
                    executionContextId = (ExecutionContextId)input.read(ExecutionContextId.class);
                    continue block34;
                }
                case "hash": {
                    hash = input.nextString();
                    continue block34;
                }
                case "executionContextAuxData": {
                    executionContextAuxData = (Map)input.read(new TypeToken<Map<String, Object>>(){}.getType());
                    continue block34;
                }
                case "isLiveEdit": {
                    isLiveEdit = input.nextBoolean();
                    continue block34;
                }
                case "sourceMapURL": {
                    sourceMapURL = input.nextString();
                    continue block34;
                }
                case "hasSourceURL": {
                    hasSourceURL = input.nextBoolean();
                    continue block34;
                }
                case "isModule": {
                    isModule = input.nextBoolean();
                    continue block34;
                }
                case "length": {
                    length = input.nextNumber().intValue();
                    continue block34;
                }
                case "stackTrace": {
                    stackTrace = (StackTrace)input.read(StackTrace.class);
                    continue block34;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScriptParsed(scriptId, url, startLine, startColumn, endLine, endColumn, executionContextId, hash, executionContextAuxData, isLiveEdit, sourceMapURL, hasSourceURL, isModule, length, stackTrace);
    }
}

