/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.profiler.model.ProfileNode;
import org.openqa.selenium.json.JsonInput;

public class Profile {
    private final List<ProfileNode> nodes;
    private final Instant startTime;
    private final Instant endTime;
    private final List<Integer> samples;
    private final List<Integer> timeDeltas;

    public Profile(List<ProfileNode> nodes, Instant startTime, Instant endTime, List<Integer> samples, List<Integer> timeDeltas) {
        this.validateNodes(nodes);
        Objects.requireNonNull(startTime, "startTime is require for Profile object");
        Objects.requireNonNull(endTime, "endTime is require for Profile object");
        this.nodes = nodes;
        this.startTime = startTime;
        this.endTime = endTime;
        this.samples = samples;
        this.timeDeltas = timeDeltas;
    }

    public List<ProfileNode> getNodes() {
        return this.nodes;
    }

    private static Profile fromJson(JsonInput input) {
        ArrayList<ProfileNode> nodes = null;
        Instant startTime = null;
        Instant endTime = null;
        ArrayList<Integer> samples = null;
        ArrayList<Integer> timeDeltas = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodes": {
                    nodes = new ArrayList<ProfileNode>();
                    input.beginArray();
                    while (input.hasNext()) {
                        nodes.add((ProfileNode)input.read(ProfileNode.class));
                    }
                    input.endArray();
                    continue block14;
                }
                case "startTime": {
                    startTime = input.nextInstant();
                    continue block14;
                }
                case "endTime": {
                    endTime = input.nextInstant();
                    continue block14;
                }
                case "samples": {
                    samples = new ArrayList<Integer>();
                    input.beginArray();
                    while (input.hasNext()) {
                        samples.add((Integer)input.read(Integer.class));
                    }
                    input.endArray();
                    continue block14;
                }
                case "timeDeltas": {
                    timeDeltas = new ArrayList<Integer>();
                    input.beginArray();
                    while (input.hasNext()) {
                        timeDeltas.add((Integer)input.read(Integer.class));
                    }
                    input.endArray();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Profile(nodes, startTime, endTime, samples, timeDeltas);
    }

    private void validateNodes(List<ProfileNode> nodes) {
        Objects.requireNonNull(nodes, "nodes are require for Profile object");
        if (nodes.isEmpty()) {
            throw new DevToolsException("Nodes cannot be Empty Object");
        }
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public List<Integer> getSamples() {
        return this.samples;
    }

    public List<Integer> getTimeDeltas() {
        return this.timeDeltas;
    }
}

