/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.profiler.model.ConsoleProfileFinished;
import org.openqa.selenium.devtools.profiler.model.ConsoleProfileStarted;
import org.openqa.selenium.devtools.profiler.model.Profile;
import org.openqa.selenium.devtools.profiler.model.ScriptCoverage;
import org.openqa.selenium.devtools.profiler.model.ScriptTypeProfile;

public class Profiler {
    public static Command<Void> disable() {
        return new Command<Void>("Profiler.disable", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<Void> enable() {
        return new Command<Void>("Profiler.enable", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<Void> start() {
        return new Command<Void>("Profiler.start", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<Profile> stop() {
        return new Command<Profile>("Profiler.stop", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("profile", Profile.class));
    }

    public static Command<List<ScriptCoverage>> getBestEffortCoverage() {
        return new Command<List<ScriptCoverage>>("Profiler.getBestEffortCoverage", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("result", new TypeToken<List<ScriptCoverage>>(){}.getType()));
    }

    public static Command<Void> setSamplingInterval(int interval) {
        return new Command<Void>("Profiler.setSamplingInterval", (Map<String, Object>)ImmutableMap.of((Object)"interval", (Object)interval));
    }

    public static Command<Void> startPreciseCoverage(Optional<Boolean> callCount, Optional<Boolean> detailed) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        callCount.ifPresent(value -> mapBuilder.put((Object)"callCount", value));
        detailed.ifPresent(value -> mapBuilder.put((Object)"detailed", value));
        return new Command<Void>("Profiler.startPreciseCoverage", (Map<String, Object>)mapBuilder.build());
    }

    @Beta
    public static Command<Void> startTypeProfile() {
        return new Command<Void>("Profiler.startTypeProfile", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<Void> stopPreciseCoverage() {
        return new Command<Void>("Profiler.stopPreciseCoverage", (Map<String, Object>)ImmutableMap.of());
    }

    @Beta
    public static Command<Void> stopTypeProfile() {
        return new Command<Void>("Profiler.stopTypeProfile", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<List<ScriptCoverage>> takePreciseCoverage() {
        return new Command<List<ScriptCoverage>>("Profiler.takePreciseCoverage", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("result", new TypeToken<List<ScriptCoverage>>(){}.getType()));
    }

    @Beta
    public static Command<List<ScriptCoverage>> takeTypeProfile() {
        return new Command<List<ScriptCoverage>>("Profiler.takeTypeProfile", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("result", new TypeToken<List<ScriptTypeProfile>>(){}.getType()));
    }

    public static Event<ConsoleProfileFinished> consoleProfileFinished() {
        return new Event<ConsoleProfileFinished>("Profiler.consoleProfileFinished", ConverterFunctions.map("id", ConsoleProfileFinished.class));
    }

    public static Event<ConsoleProfileStarted> consoleProfileStarted() {
        return new Event<ConsoleProfileStarted>("Profiler.consoleProfileStarted", ConverterFunctions.map("id", ConsoleProfileStarted.class));
    }
}

