/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.fetch.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.fetch.model.RequestId;
import org.openqa.selenium.devtools.network.model.ErrorReason;
import org.openqa.selenium.devtools.network.model.Request;
import org.openqa.selenium.devtools.network.model.ResourceType;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class RequestPaused {
    private final RequestId requestId;
    private final Request request;
    private final FrameId frameId;
    private final ResourceType resourceType;
    private final ErrorReason responseErrorReason;
    private final Integer responseStatusCode;
    private final List<HeaderEntry> responseHeaders;
    private final RequestId networkId;

    public RequestPaused(RequestId requestId, Request request, FrameId frameId, ResourceType resourceType, ErrorReason responseErrorReason, Integer responseStatusCode, List<HeaderEntry> responseHeaders, RequestId networkId) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.request = Objects.requireNonNull(request, "request is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.resourceType = Objects.requireNonNull(resourceType, "resourceType is requiredd");
        this.responseErrorReason = responseErrorReason;
        this.responseStatusCode = responseStatusCode;
        this.responseHeaders = responseHeaders;
        this.networkId = networkId;
    }

    private static RequestPaused fromJson(JsonInput input) {
        RequestId requestId = (RequestId)input.read(RequestId.class);
        Request request = null;
        FrameId frameId = null;
        ResourceType resourceType = null;
        ErrorReason responseErrorReason = null;
        Integer responseStatusCode = null;
        ArrayList<HeaderEntry> responseHeaders = null;
        RequestId networkId = null;
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "request": {
                    request = (Request)input.read(Request.class);
                    continue block14;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block14;
                }
                case "resourceType": {
                    resourceType = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block14;
                }
                case "responseStatusCode": {
                    responseStatusCode = (Integer)input.read(Integer.class);
                    continue block14;
                }
                case "responseHeaders": {
                    responseHeaders = new ArrayList<HeaderEntry>();
                    input.beginArray();
                    while (input.hasNext()) {
                        responseHeaders.add((HeaderEntry)input.read(HeaderEntry.class));
                    }
                    input.endArray();
                    continue block14;
                }
            }
            input.skipValue();
        }
        return new RequestPaused(requestId, request, frameId, resourceType, responseErrorReason, responseStatusCode, responseHeaders, networkId);
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Request getRequest() {
        return this.request;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public ErrorReason getResponseErrorReason() {
        return this.responseErrorReason;
    }

    public Integer getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public List<HeaderEntry> getResponseHeaders() {
        return this.responseHeaders;
    }

    public RequestId getNetworkId() {
        return this.networkId;
    }
}

