package org.openqa.selenium.devtools.v91.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired exactly once for each Trust Token operation. Depending on
 * the type of the operation and whether the operation succeeded or
 * failed, the event is fired before the corresponding request was sent
 * or after the response was received.
 */
@org.openqa.selenium.Beta()
public class TrustTokenOperationDone {

    public enum Status {

        OK("Ok"),
        INVALIDARGUMENT("InvalidArgument"),
        FAILEDPRECONDITION("FailedPrecondition"),
        RESOURCEEXHAUSTED("ResourceExhausted"),
        ALREADYEXISTS("AlreadyExists"),
        UNAVAILABLE("Unavailable"),
        BADRESPONSE("BadResponse"),
        INTERNALERROR("InternalError"),
        UNKNOWNERROR("UnknownError"),
        FULFILLEDLOCALLY("FulfilledLocally");

        private String value;

        Status(String value) {
            this.value = value;
        }

        public static Status fromString(String s) {
            return java.util.Arrays.stream(Status.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Status "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Status fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Status status;

    private final org.openqa.selenium.devtools.v91.network.model.TrustTokenOperationType type;

    private final org.openqa.selenium.devtools.v91.network.model.RequestId requestId;

    private final java.util.Optional<java.lang.String> topLevelOrigin;

    private final java.util.Optional<java.lang.String> issuerOrigin;

    private final java.util.Optional<java.lang.Integer> issuedTokenCount;

    public TrustTokenOperationDone(Status status, org.openqa.selenium.devtools.v91.network.model.TrustTokenOperationType type, org.openqa.selenium.devtools.v91.network.model.RequestId requestId, java.util.Optional<java.lang.String> topLevelOrigin, java.util.Optional<java.lang.String> issuerOrigin, java.util.Optional<java.lang.Integer> issuedTokenCount) {
        this.status = java.util.Objects.requireNonNull(status, "status is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.topLevelOrigin = topLevelOrigin;
        this.issuerOrigin = issuerOrigin;
        this.issuedTokenCount = issuedTokenCount;
    }

    /**
     * Detailed success or error status of the operation.
     * 'AlreadyExists' also signifies a successful operation, as the result
     * of the operation already exists und thus, the operation was abort
     * preemptively (e.g. a cache hit).
     */
    public Status getStatus() {
        return status;
    }

    public org.openqa.selenium.devtools.v91.network.model.TrustTokenOperationType getType() {
        return type;
    }

    public org.openqa.selenium.devtools.v91.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * Top level origin. The context in which the operation was attempted.
     */
    public java.util.Optional<java.lang.String> getTopLevelOrigin() {
        return topLevelOrigin;
    }

    /**
     * Origin of the issuer in case of a "Issuance" or "Redemption" operation.
     */
    public java.util.Optional<java.lang.String> getIssuerOrigin() {
        return issuerOrigin;
    }

    /**
     * The number of obtained Trust Tokens on a successful "Issuance" operation.
     */
    public java.util.Optional<java.lang.Integer> getIssuedTokenCount() {
        return issuedTokenCount;
    }

    private static TrustTokenOperationDone fromJson(JsonInput input) {
        Status status = null;
        org.openqa.selenium.devtools.v91.network.model.TrustTokenOperationType type = null;
        org.openqa.selenium.devtools.v91.network.model.RequestId requestId = null;
        java.util.Optional<java.lang.String> topLevelOrigin = java.util.Optional.empty();
        java.util.Optional<java.lang.String> issuerOrigin = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> issuedTokenCount = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "status":
                    status = Status.fromString(input.nextString());
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v91.network.model.TrustTokenOperationType.class);
                    break;
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v91.network.model.RequestId.class);
                    break;
                case "topLevelOrigin":
                    topLevelOrigin = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "issuerOrigin":
                    issuerOrigin = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "issuedTokenCount":
                    issuedTokenCount = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new TrustTokenOperationDone(status, type, requestId, topLevelOrigin, issuerOrigin, issuedTokenCount);
    }
}
