package org.openqa.selenium.devtools.v91.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This information is currently necessary, as the front-end has a difficult
 * time finding a specific cookie. With this, we can convey specific error
 * information without the cookie.
 */
public class SameSiteCookieIssueDetails {

    private final org.openqa.selenium.devtools.v91.audits.model.AffectedCookie cookie;

    private final java.util.List<org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieWarningReason> cookieWarningReasons;

    private final java.util.List<org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieExclusionReason> cookieExclusionReasons;

    private final org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieOperation operation;

    private final java.util.Optional<java.lang.String> siteForCookies;

    private final java.util.Optional<java.lang.String> cookieUrl;

    private final java.util.Optional<org.openqa.selenium.devtools.v91.audits.model.AffectedRequest> request;

    public SameSiteCookieIssueDetails(org.openqa.selenium.devtools.v91.audits.model.AffectedCookie cookie, java.util.List<org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieWarningReason> cookieWarningReasons, java.util.List<org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieExclusionReason> cookieExclusionReasons, org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieOperation operation, java.util.Optional<java.lang.String> siteForCookies, java.util.Optional<java.lang.String> cookieUrl, java.util.Optional<org.openqa.selenium.devtools.v91.audits.model.AffectedRequest> request) {
        this.cookie = java.util.Objects.requireNonNull(cookie, "cookie is required");
        this.cookieWarningReasons = java.util.Objects.requireNonNull(cookieWarningReasons, "cookieWarningReasons is required");
        this.cookieExclusionReasons = java.util.Objects.requireNonNull(cookieExclusionReasons, "cookieExclusionReasons is required");
        this.operation = java.util.Objects.requireNonNull(operation, "operation is required");
        this.siteForCookies = siteForCookies;
        this.cookieUrl = cookieUrl;
        this.request = request;
    }

    public org.openqa.selenium.devtools.v91.audits.model.AffectedCookie getCookie() {
        return cookie;
    }

    public java.util.List<org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieWarningReason> getCookieWarningReasons() {
        return cookieWarningReasons;
    }

    public java.util.List<org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieExclusionReason> getCookieExclusionReasons() {
        return cookieExclusionReasons;
    }

    /**
     * Optionally identifies the site-for-cookies and the cookie url, which
     * may be used by the front-end as additional context.
     */
    public org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieOperation getOperation() {
        return operation;
    }

    public java.util.Optional<java.lang.String> getSiteForCookies() {
        return siteForCookies;
    }

    public java.util.Optional<java.lang.String> getCookieUrl() {
        return cookieUrl;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v91.audits.model.AffectedRequest> getRequest() {
        return request;
    }

    private static SameSiteCookieIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v91.audits.model.AffectedCookie cookie = null;
        java.util.List<org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieWarningReason> cookieWarningReasons = null;
        java.util.List<org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieExclusionReason> cookieExclusionReasons = null;
        org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieOperation operation = null;
        java.util.Optional<java.lang.String> siteForCookies = java.util.Optional.empty();
        java.util.Optional<java.lang.String> cookieUrl = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v91.audits.model.AffectedRequest> request = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "cookie":
                    cookie = input.read(org.openqa.selenium.devtools.v91.audits.model.AffectedCookie.class);
                    break;
                case "cookieWarningReasons":
                    cookieWarningReasons = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieWarningReason>>() {
                    }.getType());
                    break;
                case "cookieExclusionReasons":
                    cookieExclusionReasons = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieExclusionReason>>() {
                    }.getType());
                    break;
                case "operation":
                    operation = input.read(org.openqa.selenium.devtools.v91.audits.model.SameSiteCookieOperation.class);
                    break;
                case "siteForCookies":
                    siteForCookies = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "cookieUrl":
                    cookieUrl = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "request":
                    request = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v91.audits.model.AffectedRequest.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SameSiteCookieIssueDetails(cookie, cookieWarningReasons, cookieExclusionReasons, operation, siteForCookies, cookieUrl, request);
    }
}
