package org.openqa.selenium.devtools.v85.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Cookie parameter object
 */
public class CookieParam {

    private final java.lang.String name;

    private final java.lang.String value;

    private final java.util.Optional<java.lang.String> url;

    private final java.util.Optional<java.lang.String> domain;

    private final java.util.Optional<java.lang.String> path;

    private final java.util.Optional<java.lang.Boolean> secure;

    private final java.util.Optional<java.lang.Boolean> httpOnly;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.network.model.CookieSameSite> sameSite;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.network.model.TimeSinceEpoch> expires;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.network.model.CookiePriority> priority;

    public CookieParam(java.lang.String name, java.lang.String value, java.util.Optional<java.lang.String> url, java.util.Optional<java.lang.String> domain, java.util.Optional<java.lang.String> path, java.util.Optional<java.lang.Boolean> secure, java.util.Optional<java.lang.Boolean> httpOnly, java.util.Optional<org.openqa.selenium.devtools.v85.network.model.CookieSameSite> sameSite, java.util.Optional<org.openqa.selenium.devtools.v85.network.model.TimeSinceEpoch> expires, java.util.Optional<org.openqa.selenium.devtools.v85.network.model.CookiePriority> priority) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.value = java.util.Objects.requireNonNull(value, "value is required");
        this.url = url;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.sameSite = sameSite;
        this.expires = expires;
        this.priority = priority;
    }

    /**
     * Cookie name.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * Cookie value.
     */
    public java.lang.String getValue() {
        return value;
    }

    /**
     * The request-URI to associate with the setting of the cookie. This value can affect the
     * default domain and path values of the created cookie.
     */
    public java.util.Optional<java.lang.String> getUrl() {
        return url;
    }

    /**
     * Cookie domain.
     */
    public java.util.Optional<java.lang.String> getDomain() {
        return domain;
    }

    /**
     * Cookie path.
     */
    public java.util.Optional<java.lang.String> getPath() {
        return path;
    }

    /**
     * True if cookie is secure.
     */
    public java.util.Optional<java.lang.Boolean> getSecure() {
        return secure;
    }

    /**
     * True if cookie is http-only.
     */
    public java.util.Optional<java.lang.Boolean> getHttpOnly() {
        return httpOnly;
    }

    /**
     * Cookie SameSite type.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.network.model.CookieSameSite> getSameSite() {
        return sameSite;
    }

    /**
     * Cookie expiration date, session cookie if not set
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.network.model.TimeSinceEpoch> getExpires() {
        return expires;
    }

    /**
     * Cookie Priority.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v85.network.model.CookiePriority> getPriority() {
        return priority;
    }

    private static CookieParam fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.String value = null;
        java.util.Optional<java.lang.String> url = java.util.Optional.empty();
        java.util.Optional<java.lang.String> domain = java.util.Optional.empty();
        java.util.Optional<java.lang.String> path = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> secure = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> httpOnly = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.network.model.CookieSameSite> sameSite = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.network.model.TimeSinceEpoch> expires = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.network.model.CookiePriority> priority = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "value":
                    value = input.nextString();
                    break;
                case "url":
                    url = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "domain":
                    domain = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "path":
                    path = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "secure":
                    secure = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "httpOnly":
                    httpOnly = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "sameSite":
                    sameSite = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.network.model.CookieSameSite.class));
                    break;
                case "expires":
                    expires = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.network.model.TimeSinceEpoch.class));
                    break;
                case "priority":
                    priority = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.network.model.CookiePriority.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CookieParam(name, value, url, domain, path, secure, httpOnly, sameSite, expires, priority);
    }
}
