/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v145.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v145.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class EventSourceMessageReceived {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final String eventName;
    private final String eventId;
    private final String data;

    public EventSourceMessageReceived(RequestId requestId, MonotonicTime timestamp, String eventName, String eventId, String data) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.eventName = Objects.requireNonNull(eventName, "eventName is required");
        this.eventId = Objects.requireNonNull(eventId, "eventId is required");
        this.data = Objects.requireNonNull(data, "data is required");
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getData() {
        return this.data;
    }

    private static EventSourceMessageReceived fromJson(JsonInput input) {
        RequestId requestId = null;
        MonotonicTime timestamp = null;
        String eventName = null;
        String eventId = null;
        String data = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block14;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block14;
                }
                case "eventName": {
                    eventName = input.nextString();
                    continue block14;
                }
                case "eventId": {
                    eventId = input.nextString();
                    continue block14;
                }
                case "data": {
                    data = input.nextString();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new EventSourceMessageReceived(requestId, timestamp, eventName, eventId, data);
    }
}

