/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.network.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v145.network.model.DeviceBoundSessionCookieCraving;
import org.openqa.selenium.devtools.v145.network.model.DeviceBoundSessionInclusionRules;
import org.openqa.selenium.devtools.v145.network.model.DeviceBoundSessionKey;
import org.openqa.selenium.devtools.v145.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DeviceBoundSession {
    private final DeviceBoundSessionKey key;
    private final String refreshUrl;
    private final DeviceBoundSessionInclusionRules inclusionRules;
    private final List<DeviceBoundSessionCookieCraving> cookieCravings;
    private final TimeSinceEpoch expiryDate;
    private final Optional<String> cachedChallenge;
    private final List<String> allowedRefreshInitiators;

    public DeviceBoundSession(DeviceBoundSessionKey key, String refreshUrl, DeviceBoundSessionInclusionRules inclusionRules, List<DeviceBoundSessionCookieCraving> cookieCravings, TimeSinceEpoch expiryDate, Optional<String> cachedChallenge, List<String> allowedRefreshInitiators) {
        this.key = Objects.requireNonNull(key, "key is required");
        this.refreshUrl = Objects.requireNonNull(refreshUrl, "refreshUrl is required");
        this.inclusionRules = Objects.requireNonNull(inclusionRules, "inclusionRules is required");
        this.cookieCravings = Objects.requireNonNull(cookieCravings, "cookieCravings is required");
        this.expiryDate = Objects.requireNonNull(expiryDate, "expiryDate is required");
        this.cachedChallenge = cachedChallenge;
        this.allowedRefreshInitiators = Objects.requireNonNull(allowedRefreshInitiators, "allowedRefreshInitiators is required");
    }

    public DeviceBoundSessionKey getKey() {
        return this.key;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public DeviceBoundSessionInclusionRules getInclusionRules() {
        return this.inclusionRules;
    }

    public List<DeviceBoundSessionCookieCraving> getCookieCravings() {
        return this.cookieCravings;
    }

    public TimeSinceEpoch getExpiryDate() {
        return this.expiryDate;
    }

    public Optional<String> getCachedChallenge() {
        return this.cachedChallenge;
    }

    public List<String> getAllowedRefreshInitiators() {
        return this.allowedRefreshInitiators;
    }

    private static DeviceBoundSession fromJson(JsonInput input) {
        DeviceBoundSessionKey key = null;
        String refreshUrl = null;
        DeviceBoundSessionInclusionRules inclusionRules = null;
        List cookieCravings = null;
        TimeSinceEpoch expiryDate = null;
        Optional<String> cachedChallenge = Optional.empty();
        List allowedRefreshInitiators = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "key": {
                    key = (DeviceBoundSessionKey)input.read(DeviceBoundSessionKey.class);
                    continue block18;
                }
                case "refreshUrl": {
                    refreshUrl = input.nextString();
                    continue block18;
                }
                case "inclusionRules": {
                    inclusionRules = (DeviceBoundSessionInclusionRules)input.read(DeviceBoundSessionInclusionRules.class);
                    continue block18;
                }
                case "cookieCravings": {
                    cookieCravings = input.readArray(DeviceBoundSessionCookieCraving.class);
                    continue block18;
                }
                case "expiryDate": {
                    expiryDate = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block18;
                }
                case "cachedChallenge": {
                    cachedChallenge = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "allowedRefreshInitiators": {
                    allowedRefreshInitiators = input.readArray(String.class);
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeviceBoundSession(key, refreshUrl, inclusionRules, cookieCravings, expiryDate, cachedChallenge, allowedRefreshInitiators);
    }
}

