/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.storage.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class IndexedDBContentUpdated {
    private final String origin;
    private final String storageKey;
    private final String bucketId;
    private final String databaseName;
    private final String objectStoreName;

    public IndexedDBContentUpdated(String origin, String storageKey, String bucketId, String databaseName, String objectStoreName) {
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.storageKey = Objects.requireNonNull(storageKey, "storageKey is required");
        this.bucketId = Objects.requireNonNull(bucketId, "bucketId is required");
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is required");
        this.objectStoreName = Objects.requireNonNull(objectStoreName, "objectStoreName is required");
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getStorageKey() {
        return this.storageKey;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getObjectStoreName() {
        return this.objectStoreName;
    }

    private static IndexedDBContentUpdated fromJson(JsonInput input) {
        String origin = null;
        String storageKey = null;
        String bucketId = null;
        String databaseName = null;
        String objectStoreName = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "origin": {
                    origin = input.nextString();
                    continue block14;
                }
                case "storageKey": {
                    storageKey = input.nextString();
                    continue block14;
                }
                case "bucketId": {
                    bucketId = input.nextString();
                    continue block14;
                }
                case "databaseName": {
                    databaseName = input.nextString();
                    continue block14;
                }
                case "objectStoreName": {
                    objectStoreName = input.nextString();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new IndexedDBContentUpdated(origin, storageKey, bucketId, databaseName, objectStoreName);
    }
}

