/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.css.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v144.css.model.CSSContainerQuery;
import org.openqa.selenium.devtools.v144.css.model.CSSLayer;
import org.openqa.selenium.devtools.v144.css.model.CSSMedia;
import org.openqa.selenium.devtools.v144.css.model.CSSRuleType;
import org.openqa.selenium.devtools.v144.css.model.CSSScope;
import org.openqa.selenium.devtools.v144.css.model.CSSStartingStyle;
import org.openqa.selenium.devtools.v144.css.model.CSSStyle;
import org.openqa.selenium.devtools.v144.css.model.CSSSupports;
import org.openqa.selenium.devtools.v144.css.model.SelectorList;
import org.openqa.selenium.devtools.v144.css.model.StyleSheetOrigin;
import org.openqa.selenium.devtools.v144.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v144.dom.model.StyleSheetId;
import org.openqa.selenium.json.JsonInput;

public class CSSRule {
    private final Optional<StyleSheetId> styleSheetId;
    private final SelectorList selectorList;
    private final Optional<List<String>> nestingSelectors;
    private final StyleSheetOrigin origin;
    private final CSSStyle style;
    private final Optional<BackendNodeId> originTreeScopeNodeId;
    private final Optional<List<CSSMedia>> media;
    private final Optional<List<CSSContainerQuery>> containerQueries;
    private final Optional<List<CSSSupports>> supports;
    private final Optional<List<CSSLayer>> layers;
    private final Optional<List<CSSScope>> scopes;
    private final Optional<List<CSSRuleType>> ruleTypes;
    private final Optional<List<CSSStartingStyle>> startingStyles;

    public CSSRule(Optional<StyleSheetId> styleSheetId, SelectorList selectorList, Optional<List<String>> nestingSelectors, StyleSheetOrigin origin, CSSStyle style, Optional<BackendNodeId> originTreeScopeNodeId, Optional<List<CSSMedia>> media, Optional<List<CSSContainerQuery>> containerQueries, Optional<List<CSSSupports>> supports, Optional<List<CSSLayer>> layers, Optional<List<CSSScope>> scopes, Optional<List<CSSRuleType>> ruleTypes, Optional<List<CSSStartingStyle>> startingStyles) {
        this.styleSheetId = styleSheetId;
        this.selectorList = Objects.requireNonNull(selectorList, "selectorList is required");
        this.nestingSelectors = nestingSelectors;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.style = Objects.requireNonNull(style, "style is required");
        this.originTreeScopeNodeId = originTreeScopeNodeId;
        this.media = media;
        this.containerQueries = containerQueries;
        this.supports = supports;
        this.layers = layers;
        this.scopes = scopes;
        this.ruleTypes = ruleTypes;
        this.startingStyles = startingStyles;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public SelectorList getSelectorList() {
        return this.selectorList;
    }

    @Beta
    public Optional<List<String>> getNestingSelectors() {
        return this.nestingSelectors;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    @Beta
    public Optional<BackendNodeId> getOriginTreeScopeNodeId() {
        return this.originTreeScopeNodeId;
    }

    public Optional<List<CSSMedia>> getMedia() {
        return this.media;
    }

    @Beta
    public Optional<List<CSSContainerQuery>> getContainerQueries() {
        return this.containerQueries;
    }

    @Beta
    public Optional<List<CSSSupports>> getSupports() {
        return this.supports;
    }

    @Beta
    public Optional<List<CSSLayer>> getLayers() {
        return this.layers;
    }

    @Beta
    public Optional<List<CSSScope>> getScopes() {
        return this.scopes;
    }

    @Beta
    public Optional<List<CSSRuleType>> getRuleTypes() {
        return this.ruleTypes;
    }

    @Beta
    public Optional<List<CSSStartingStyle>> getStartingStyles() {
        return this.startingStyles;
    }

    private static CSSRule fromJson(JsonInput input) {
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        SelectorList selectorList = null;
        Optional<List<String>> nestingSelectors = Optional.empty();
        StyleSheetOrigin origin = null;
        CSSStyle style = null;
        Optional<BackendNodeId> originTreeScopeNodeId = Optional.empty();
        Optional<List<CSSMedia>> media = Optional.empty();
        Optional<List<CSSContainerQuery>> containerQueries = Optional.empty();
        Optional<List<CSSSupports>> supports = Optional.empty();
        Optional<List<CSSLayer>> layers = Optional.empty();
        Optional<List<CSSScope>> scopes = Optional.empty();
        Optional<List<CSSRuleType>> ruleTypes = Optional.empty();
        Optional<List<CSSStartingStyle>> startingStyles = Optional.empty();
        input.beginObject();
        block30: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block30;
                }
                case "selectorList": {
                    selectorList = (SelectorList)input.read(SelectorList.class);
                    continue block30;
                }
                case "nestingSelectors": {
                    nestingSelectors = Optional.ofNullable(input.readArray(String.class));
                    continue block30;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read(StyleSheetOrigin.class));
                    continue block30;
                }
                case "style": {
                    style = (CSSStyle)input.read(CSSStyle.class);
                    continue block30;
                }
                case "originTreeScopeNodeId": {
                    originTreeScopeNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block30;
                }
                case "media": {
                    media = Optional.ofNullable(input.readArray(CSSMedia.class));
                    continue block30;
                }
                case "containerQueries": {
                    containerQueries = Optional.ofNullable(input.readArray(CSSContainerQuery.class));
                    continue block30;
                }
                case "supports": {
                    supports = Optional.ofNullable(input.readArray(CSSSupports.class));
                    continue block30;
                }
                case "layers": {
                    layers = Optional.ofNullable(input.readArray(CSSLayer.class));
                    continue block30;
                }
                case "scopes": {
                    scopes = Optional.ofNullable(input.readArray(CSSScope.class));
                    continue block30;
                }
                case "ruleTypes": {
                    ruleTypes = Optional.ofNullable(input.readArray(CSSRuleType.class));
                    continue block30;
                }
                case "startingStyles": {
                    startingStyles = Optional.ofNullable(input.readArray(CSSStartingStyle.class));
                    continue block30;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSRule(styleSheetId, selectorList, nestingSelectors, origin, style, originTreeScopeNodeId, media, containerQueries, supports, layers, scopes, ruleTypes, startingStyles);
    }
}

