/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v143.network.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum BlockedReason {
    OTHER("other"),
    CSP("csp"),
    MIXED_CONTENT("mixed-content"),
    ORIGIN("origin"),
    INSPECTOR("inspector"),
    INTEGRITY("integrity"),
    SUBRESOURCE_FILTER("subresource-filter"),
    CONTENT_TYPE("content-type"),
    COEP_FRAME_RESOURCE_NEEDS_COEP_HEADER("coep-frame-resource-needs-coep-header"),
    COOP_SANDBOXED_IFRAME_CANNOT_NAVIGATE_TO_COOP_PAGE("coop-sandboxed-iframe-cannot-navigate-to-coop-page"),
    CORP_NOT_SAME_ORIGIN("corp-not-same-origin"),
    CORP_NOT_SAME_ORIGIN_AFTER_DEFAULTED_TO_SAME_ORIGIN_BY_COEP("corp-not-same-origin-after-defaulted-to-same-origin-by-coep"),
    CORP_NOT_SAME_ORIGIN_AFTER_DEFAULTED_TO_SAME_ORIGIN_BY_DIP("corp-not-same-origin-after-defaulted-to-same-origin-by-dip"),
    CORP_NOT_SAME_ORIGIN_AFTER_DEFAULTED_TO_SAME_ORIGIN_BY_COEP_AND_DIP("corp-not-same-origin-after-defaulted-to-same-origin-by-coep-and-dip"),
    CORP_NOT_SAME_SITE("corp-not-same-site"),
    SRI_MESSAGE_SIGNATURE_MISMATCH("sri-message-signature-mismatch");

    private String value;

    private BlockedReason(String value) {
        this.value = value;
    }

    public static BlockedReason fromString(String s) {
        return Arrays.stream(BlockedReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within BlockedReason "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static BlockedReason fromJson(JsonInput input) {
        return BlockedReason.fromString(input.nextString());
    }
}

