/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v143.cachestorage;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v143.cachestorage.model.Cache;
import org.openqa.selenium.devtools.v143.cachestorage.model.CacheId;
import org.openqa.selenium.devtools.v143.cachestorage.model.CachedResponse;
import org.openqa.selenium.devtools.v143.cachestorage.model.DataEntry;
import org.openqa.selenium.devtools.v143.cachestorage.model.Header;
import org.openqa.selenium.devtools.v143.storage.model.StorageBucket;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CacheStorage {
    public static Command<Void> deleteCache(CacheId cacheId) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        LinkedHashMap<String, CacheId> params = new LinkedHashMap<String, CacheId>();
        params.put("cacheId", cacheId);
        return new Command("CacheStorage.deleteCache", Map.copyOf(params));
    }

    public static Command<Void> deleteEntry(CacheId cacheId, String request) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        Objects.requireNonNull(request, "request is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("cacheId", cacheId);
        params.put("request", request);
        return new Command("CacheStorage.deleteEntry", Map.copyOf(params));
    }

    public static Command<List<Cache>> requestCacheNames(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket) {
        LinkedHashMap params = new LinkedHashMap();
        securityOrigin.ifPresent(p -> params.put("securityOrigin", p));
        storageKey.ifPresent(p -> params.put("storageKey", p));
        storageBucket.ifPresent(p -> params.put("storageBucket", p));
        return new Command("CacheStorage.requestCacheNames", Map.copyOf(params), ConverterFunctions.map((String)"caches", input -> input.readArray(Cache.class)));
    }

    public static Command<CachedResponse> requestCachedResponse(CacheId cacheId, String requestURL, List<Header> requestHeaders) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        Objects.requireNonNull(requestURL, "requestURL is required");
        Objects.requireNonNull(requestHeaders, "requestHeaders is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("cacheId", cacheId);
        params.put("requestURL", requestURL);
        params.put("requestHeaders", requestHeaders);
        return new Command("CacheStorage.requestCachedResponse", Map.copyOf(params), ConverterFunctions.map((String)"response", CachedResponse.class));
    }

    public static Command<RequestEntriesResponse> requestEntries(CacheId cacheId, Optional<Integer> skipCount, Optional<Integer> pageSize, Optional<String> pathFilter) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        LinkedHashMap<String, CacheId> params = new LinkedHashMap<String, CacheId>();
        params.put("cacheId", cacheId);
        skipCount.ifPresent(p -> params.put("skipCount", (CacheId)p));
        pageSize.ifPresent(p -> params.put("pageSize", (CacheId)p));
        pathFilter.ifPresent(p -> params.put("pathFilter", (CacheId)p));
        return new Command("CacheStorage.requestEntries", Map.copyOf(params), input -> (RequestEntriesResponse)input.read(RequestEntriesResponse.class));
    }

    public static class RequestEntriesResponse {
        private final List<DataEntry> cacheDataEntries;
        private final Number returnCount;

        public RequestEntriesResponse(List<DataEntry> cacheDataEntries, Number returnCount) {
            this.cacheDataEntries = Objects.requireNonNull(cacheDataEntries, "cacheDataEntries is required");
            this.returnCount = Objects.requireNonNull(returnCount, "returnCount is required");
        }

        public List<DataEntry> getCacheDataEntries() {
            return this.cacheDataEntries;
        }

        public Number getReturnCount() {
            return this.returnCount;
        }

        private static RequestEntriesResponse fromJson(JsonInput input) {
            List cacheDataEntries = null;
            Number returnCount = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "cacheDataEntries": {
                        cacheDataEntries = input.readArray(DataEntry.class);
                        continue block8;
                    }
                    case "returnCount": {
                        returnCount = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RequestEntriesResponse(cacheDataEntries, returnCount);
        }
    }
}

