package org.openqa.selenium.devtools.v139.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum AttributionReportingReportResult {

    SENT("sent"), PROHIBITED("prohibited"), FAILEDTOASSEMBLE("failedToAssemble"), EXPIRED("expired");

    private String value;

    AttributionReportingReportResult(String value) {
        this.value = value;
    }

    public static AttributionReportingReportResult fromString(String s) {
        return java.util.Arrays.stream(AttributionReportingReportResult.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AttributionReportingReportResult "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AttributionReportingReportResult fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
