package org.openqa.selenium.devtools.v139.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired once navigation of the frame has completed. Frame is now associated with the new loader.
 */
public class FrameNavigated {

    private final org.openqa.selenium.devtools.v139.page.model.Frame frame;

    private final org.openqa.selenium.devtools.v139.page.model.NavigationType type;

    public FrameNavigated(org.openqa.selenium.devtools.v139.page.model.Frame frame, org.openqa.selenium.devtools.v139.page.model.NavigationType type) {
        this.frame = java.util.Objects.requireNonNull(frame, "frame is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
    }

    /**
     * Frame object.
     */
    public org.openqa.selenium.devtools.v139.page.model.Frame getFrame() {
        return frame;
    }

    @Beta()
    public org.openqa.selenium.devtools.v139.page.model.NavigationType getType() {
        return type;
    }

    private static FrameNavigated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v139.page.model.Frame frame = null;
        org.openqa.selenium.devtools.v139.page.model.NavigationType type = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frame":
                    frame = input.read(org.openqa.selenium.devtools.v139.page.model.Frame.class);
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v139.page.model.NavigationType.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FrameNavigated(frame, type);
    }
}
