/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.storage;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v138.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v138.network.model.Cookie;
import org.openqa.selenium.devtools.v138.network.model.CookieParam;
import org.openqa.selenium.devtools.v138.page.model.FrameId;
import org.openqa.selenium.devtools.v138.storage.model.AttributionReportingReportSent;
import org.openqa.selenium.devtools.v138.storage.model.AttributionReportingSourceRegistered;
import org.openqa.selenium.devtools.v138.storage.model.AttributionReportingTriggerRegistered;
import org.openqa.selenium.devtools.v138.storage.model.CacheStorageContentUpdated;
import org.openqa.selenium.devtools.v138.storage.model.CacheStorageListUpdated;
import org.openqa.selenium.devtools.v138.storage.model.IndexedDBContentUpdated;
import org.openqa.selenium.devtools.v138.storage.model.IndexedDBListUpdated;
import org.openqa.selenium.devtools.v138.storage.model.InterestGroupAccessed;
import org.openqa.selenium.devtools.v138.storage.model.InterestGroupAuctionEventOccurred;
import org.openqa.selenium.devtools.v138.storage.model.InterestGroupAuctionNetworkRequestCreated;
import org.openqa.selenium.devtools.v138.storage.model.RelatedWebsiteSet;
import org.openqa.selenium.devtools.v138.storage.model.SerializedStorageKey;
import org.openqa.selenium.devtools.v138.storage.model.SharedStorageAccessed;
import org.openqa.selenium.devtools.v138.storage.model.SharedStorageEntry;
import org.openqa.selenium.devtools.v138.storage.model.SharedStorageMetadata;
import org.openqa.selenium.devtools.v138.storage.model.SharedStorageWorkletOperationExecutionFinished;
import org.openqa.selenium.devtools.v138.storage.model.StorageBucket;
import org.openqa.selenium.devtools.v138.storage.model.StorageBucketInfo;
import org.openqa.selenium.devtools.v138.storage.model.TrustTokens;
import org.openqa.selenium.devtools.v138.storage.model.UsageForType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Storage {
    public static Command<SerializedStorageKey> getStorageKeyForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        return new Command("Storage.getStorageKeyForFrame", Map.copyOf(params), ConverterFunctions.map((String)"storageKey", SerializedStorageKey.class));
    }

    public static Command<Void> clearDataForOrigin(String origin, String storageTypes) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        params.put("storageTypes", storageTypes);
        return new Command("Storage.clearDataForOrigin", Map.copyOf(params));
    }

    public static Command<Void> clearDataForStorageKey(String storageKey, String storageTypes) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("storageKey", storageKey);
        params.put("storageTypes", storageTypes);
        return new Command("Storage.clearDataForStorageKey", Map.copyOf(params));
    }

    public static Command<List<Cookie>> getCookies(Optional<BrowserContextID> browserContextId) {
        LinkedHashMap params = new LinkedHashMap();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command("Storage.getCookies", Map.copyOf(params), ConverterFunctions.map((String)"cookies", input -> input.readArray(Cookie.class)));
    }

    public static Command<Void> setCookies(List<CookieParam> cookies, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(cookies, "cookies is required");
        LinkedHashMap<String, List<CookieParam>> params = new LinkedHashMap<String, List<CookieParam>>();
        params.put("cookies", cookies);
        browserContextId.ifPresent(p -> params.put("browserContextId", (List<CookieParam>)p));
        return new Command("Storage.setCookies", Map.copyOf(params));
    }

    public static Command<Void> clearCookies(Optional<BrowserContextID> browserContextId) {
        LinkedHashMap params = new LinkedHashMap();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command("Storage.clearCookies", Map.copyOf(params));
    }

    public static Command<GetUsageAndQuotaResponse> getUsageAndQuota(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command("Storage.getUsageAndQuota", Map.copyOf(params), input -> (GetUsageAndQuotaResponse)input.read(GetUsageAndQuotaResponse.class));
    }

    @Beta
    public static Command<Void> overrideQuotaForOrigin(String origin, Optional<Number> quotaSize) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        quotaSize.ifPresent(p -> params.put("quotaSize", (String)p));
        return new Command("Storage.overrideQuotaForOrigin", Map.copyOf(params));
    }

    public static Command<Void> trackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command("Storage.trackCacheStorageForOrigin", Map.copyOf(params));
    }

    public static Command<Void> trackCacheStorageForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("storageKey", storageKey);
        return new Command("Storage.trackCacheStorageForStorageKey", Map.copyOf(params));
    }

    public static Command<Void> trackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command("Storage.trackIndexedDBForOrigin", Map.copyOf(params));
    }

    public static Command<Void> trackIndexedDBForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("storageKey", storageKey);
        return new Command("Storage.trackIndexedDBForStorageKey", Map.copyOf(params));
    }

    public static Command<Void> untrackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command("Storage.untrackCacheStorageForOrigin", Map.copyOf(params));
    }

    public static Command<Void> untrackCacheStorageForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("storageKey", storageKey);
        return new Command("Storage.untrackCacheStorageForStorageKey", Map.copyOf(params));
    }

    public static Command<Void> untrackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command("Storage.untrackIndexedDBForOrigin", Map.copyOf(params));
    }

    public static Command<Void> untrackIndexedDBForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("storageKey", storageKey);
        return new Command("Storage.untrackIndexedDBForStorageKey", Map.copyOf(params));
    }

    @Beta
    public static Command<List<TrustTokens>> getTrustTokens() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Storage.getTrustTokens", Map.copyOf(params), ConverterFunctions.map((String)"tokens", input -> input.readArray(TrustTokens.class)));
    }

    @Beta
    public static Command<Boolean> clearTrustTokens(String issuerOrigin) {
        Objects.requireNonNull(issuerOrigin, "issuerOrigin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("issuerOrigin", issuerOrigin);
        return new Command("Storage.clearTrustTokens", Map.copyOf(params), ConverterFunctions.map((String)"didDeleteTokens", Boolean.class));
    }

    @Beta
    public static Command<Map<String, Object>> getInterestGroupDetails(String ownerOrigin, String name) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        params.put("name", name);
        return new Command("Storage.getInterestGroupDetails", Map.copyOf(params), ConverterFunctions.map((String)"details", Map.class));
    }

    @Beta
    public static Command<Void> setInterestGroupTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enable", enable);
        return new Command("Storage.setInterestGroupTracking", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setInterestGroupAuctionTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enable", enable);
        return new Command("Storage.setInterestGroupAuctionTracking", Map.copyOf(params));
    }

    @Beta
    public static Command<SharedStorageMetadata> getSharedStorageMetadata(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command("Storage.getSharedStorageMetadata", Map.copyOf(params), ConverterFunctions.map((String)"metadata", SharedStorageMetadata.class));
    }

    @Beta
    public static Command<List<SharedStorageEntry>> getSharedStorageEntries(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command("Storage.getSharedStorageEntries", Map.copyOf(params), ConverterFunctions.map((String)"entries", input -> input.readArray(SharedStorageEntry.class)));
    }

    @Beta
    public static Command<Void> setSharedStorageEntry(String ownerOrigin, String key, String value, Optional<Boolean> ignoreIfPresent) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        params.put("key", key);
        params.put("value", value);
        ignoreIfPresent.ifPresent(p -> params.put("ignoreIfPresent", (String)p));
        return new Command("Storage.setSharedStorageEntry", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> deleteSharedStorageEntry(String ownerOrigin, String key) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(key, "key is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        params.put("key", key);
        return new Command("Storage.deleteSharedStorageEntry", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> clearSharedStorageEntries(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command("Storage.clearSharedStorageEntries", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> resetSharedStorageBudget(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command("Storage.resetSharedStorageBudget", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setSharedStorageTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enable", enable);
        return new Command("Storage.setSharedStorageTracking", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setStorageBucketTracking(String storageKey, Boolean enable) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("storageKey", storageKey);
        params.put("enable", enable);
        return new Command("Storage.setStorageBucketTracking", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> deleteStorageBucket(StorageBucket bucket) {
        Objects.requireNonNull(bucket, "bucket is required");
        LinkedHashMap<String, StorageBucket> params = new LinkedHashMap<String, StorageBucket>();
        params.put("bucket", bucket);
        return new Command("Storage.deleteStorageBucket", Map.copyOf(params));
    }

    @Beta
    public static Command<List<String>> runBounceTrackingMitigations() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Storage.runBounceTrackingMitigations", Map.copyOf(params), ConverterFunctions.map((String)"deletedSites", input -> input.readArray(String.class)));
    }

    @Beta
    public static Command<Void> setAttributionReportingLocalTestingMode(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command("Storage.setAttributionReportingLocalTestingMode", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setAttributionReportingTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enable", enable);
        return new Command("Storage.setAttributionReportingTracking", Map.copyOf(params));
    }

    @Beta
    public static Command<Integer> sendPendingAttributionReports() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Storage.sendPendingAttributionReports", Map.copyOf(params), ConverterFunctions.map((String)"numSent", Integer.class));
    }

    @Beta
    public static Command<List<RelatedWebsiteSet>> getRelatedWebsiteSets() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Storage.getRelatedWebsiteSets", Map.copyOf(params), ConverterFunctions.map((String)"sets", input -> input.readArray(RelatedWebsiteSet.class)));
    }

    @Beta
    public static Command<List<String>> getAffectedUrlsForThirdPartyCookieMetadata(String firstPartyUrl, List<String> thirdPartyUrls) {
        Objects.requireNonNull(firstPartyUrl, "firstPartyUrl is required");
        Objects.requireNonNull(thirdPartyUrls, "thirdPartyUrls is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("firstPartyUrl", firstPartyUrl);
        params.put("thirdPartyUrls", thirdPartyUrls);
        return new Command("Storage.getAffectedUrlsForThirdPartyCookieMetadata", Map.copyOf(params), ConverterFunctions.map((String)"matchedUrls", input -> input.readArray(String.class)));
    }

    public static Command<Void> setProtectedAudienceKAnonymity(String owner, String name, List<String> hashes) {
        Objects.requireNonNull(owner, "owner is required");
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(hashes, "hashes is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("owner", owner);
        params.put("name", name);
        params.put("hashes", hashes);
        return new Command("Storage.setProtectedAudienceKAnonymity", Map.copyOf(params));
    }

    public static Event<CacheStorageContentUpdated> cacheStorageContentUpdated() {
        return new Event("Storage.cacheStorageContentUpdated", input -> (CacheStorageContentUpdated)input.read(CacheStorageContentUpdated.class));
    }

    public static Event<CacheStorageListUpdated> cacheStorageListUpdated() {
        return new Event("Storage.cacheStorageListUpdated", input -> (CacheStorageListUpdated)input.read(CacheStorageListUpdated.class));
    }

    public static Event<IndexedDBContentUpdated> indexedDBContentUpdated() {
        return new Event("Storage.indexedDBContentUpdated", input -> (IndexedDBContentUpdated)input.read(IndexedDBContentUpdated.class));
    }

    public static Event<IndexedDBListUpdated> indexedDBListUpdated() {
        return new Event("Storage.indexedDBListUpdated", input -> (IndexedDBListUpdated)input.read(IndexedDBListUpdated.class));
    }

    public static Event<InterestGroupAccessed> interestGroupAccessed() {
        return new Event("Storage.interestGroupAccessed", input -> (InterestGroupAccessed)input.read(InterestGroupAccessed.class));
    }

    public static Event<InterestGroupAuctionEventOccurred> interestGroupAuctionEventOccurred() {
        return new Event("Storage.interestGroupAuctionEventOccurred", input -> (InterestGroupAuctionEventOccurred)input.read(InterestGroupAuctionEventOccurred.class));
    }

    public static Event<InterestGroupAuctionNetworkRequestCreated> interestGroupAuctionNetworkRequestCreated() {
        return new Event("Storage.interestGroupAuctionNetworkRequestCreated", input -> (InterestGroupAuctionNetworkRequestCreated)input.read(InterestGroupAuctionNetworkRequestCreated.class));
    }

    public static Event<SharedStorageAccessed> sharedStorageAccessed() {
        return new Event("Storage.sharedStorageAccessed", input -> (SharedStorageAccessed)input.read(SharedStorageAccessed.class));
    }

    public static Event<SharedStorageWorkletOperationExecutionFinished> sharedStorageWorkletOperationExecutionFinished() {
        return new Event("Storage.sharedStorageWorkletOperationExecutionFinished", input -> (SharedStorageWorkletOperationExecutionFinished)input.read(SharedStorageWorkletOperationExecutionFinished.class));
    }

    public static Event<StorageBucketInfo> storageBucketCreatedOrUpdated() {
        return new Event("Storage.storageBucketCreatedOrUpdated", ConverterFunctions.map((String)"bucketInfo", StorageBucketInfo.class));
    }

    public static Event<String> storageBucketDeleted() {
        return new Event("Storage.storageBucketDeleted", ConverterFunctions.map((String)"bucketId", String.class));
    }

    public static Event<AttributionReportingSourceRegistered> attributionReportingSourceRegistered() {
        return new Event("Storage.attributionReportingSourceRegistered", input -> (AttributionReportingSourceRegistered)input.read(AttributionReportingSourceRegistered.class));
    }

    public static Event<AttributionReportingTriggerRegistered> attributionReportingTriggerRegistered() {
        return new Event("Storage.attributionReportingTriggerRegistered", input -> (AttributionReportingTriggerRegistered)input.read(AttributionReportingTriggerRegistered.class));
    }

    public static Event<AttributionReportingReportSent> attributionReportingReportSent() {
        return new Event("Storage.attributionReportingReportSent", input -> (AttributionReportingReportSent)input.read(AttributionReportingReportSent.class));
    }

    public static class GetUsageAndQuotaResponse {
        private final Number usage;
        private final Number quota;
        private final Boolean overrideActive;
        private final List<UsageForType> usageBreakdown;

        public GetUsageAndQuotaResponse(Number usage, Number quota, Boolean overrideActive, List<UsageForType> usageBreakdown) {
            this.usage = Objects.requireNonNull(usage, "usage is required");
            this.quota = Objects.requireNonNull(quota, "quota is required");
            this.overrideActive = Objects.requireNonNull(overrideActive, "overrideActive is required");
            this.usageBreakdown = Objects.requireNonNull(usageBreakdown, "usageBreakdown is required");
        }

        public Number getUsage() {
            return this.usage;
        }

        public Number getQuota() {
            return this.quota;
        }

        public Boolean getOverrideActive() {
            return this.overrideActive;
        }

        public List<UsageForType> getUsageBreakdown() {
            return this.usageBreakdown;
        }

        private static GetUsageAndQuotaResponse fromJson(JsonInput input) {
            Number usage = 0;
            Number quota = 0;
            Boolean overrideActive = false;
            List usageBreakdown = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usage": {
                        usage = input.nextNumber();
                        continue block12;
                    }
                    case "quota": {
                        quota = input.nextNumber();
                        continue block12;
                    }
                    case "overrideActive": {
                        overrideActive = input.nextBoolean();
                        continue block12;
                    }
                    case "usageBreakdown": {
                        usageBreakdown = input.readArray(UsageForType.class);
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetUsageAndQuotaResponse(usage, quota, overrideActive, usageBreakdown);
        }
    }
}

