package org.openqa.selenium.devtools.v138.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS Starting Style at-rule descriptor.
 */
@org.openqa.selenium.Beta()
public class CSSStartingStyle {

    private final java.util.Optional<org.openqa.selenium.devtools.v138.css.model.SourceRange> range;

    private final java.util.Optional<org.openqa.selenium.devtools.v138.css.model.StyleSheetId> styleSheetId;

    public CSSStartingStyle(java.util.Optional<org.openqa.selenium.devtools.v138.css.model.SourceRange> range, java.util.Optional<org.openqa.selenium.devtools.v138.css.model.StyleSheetId> styleSheetId) {
        this.range = range;
        this.styleSheetId = styleSheetId;
    }

    /**
     * The associated rule header range in the enclosing stylesheet (if
     * available).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v138.css.model.SourceRange> getRange() {
        return range;
    }

    /**
     * Identifier of the stylesheet containing this object (if exists).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v138.css.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    private static CSSStartingStyle fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v138.css.model.SourceRange> range = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v138.css.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "range":
                    range = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v138.css.model.SourceRange.class));
                    break;
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v138.css.model.StyleSheetId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSStartingStyle(range, styleSheetId);
    }
}
