package org.openqa.selenium.devtools.v137.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Parsed app manifest properties.
 */
@org.openqa.selenium.Beta()
public class AppManifestParsedProperties {

    private final java.lang.String scope;

    public AppManifestParsedProperties(java.lang.String scope) {
        this.scope = java.util.Objects.requireNonNull(scope, "scope is required");
    }

    /**
     * Computed scope value
     */
    public java.lang.String getScope() {
        return scope;
    }

    private static AppManifestParsedProperties fromJson(JsonInput input) {
        java.lang.String scope = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "scope":
                    scope = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AppManifestParsedProperties(scope);
    }
}
