package org.openqa.selenium.devtools.v136.storage;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class Storage {

    /**
     * Returns a storage key given a frame id.
     */
    public static Command<org.openqa.selenium.devtools.v136.storage.model.SerializedStorageKey> getStorageKeyForFrame(org.openqa.selenium.devtools.v136.page.model.FrameId frameId) {
        java.util.Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("frameId", frameId);
        return new Command<>("Storage.getStorageKeyForFrame", Map.copyOf(params), ConverterFunctions.map("storageKey", org.openqa.selenium.devtools.v136.storage.model.SerializedStorageKey.class));
    }

    /**
     * Clears storage for origin.
     */
    public static Command<Void> clearDataForOrigin(java.lang.String origin, java.lang.String storageTypes) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        java.util.Objects.requireNonNull(storageTypes, "storageTypes is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("origin", origin);
        params.put("storageTypes", storageTypes);
        return new Command<>("Storage.clearDataForOrigin", Map.copyOf(params));
    }

    /**
     * Clears storage for storage key.
     */
    public static Command<Void> clearDataForStorageKey(java.lang.String storageKey, java.lang.String storageTypes) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        java.util.Objects.requireNonNull(storageTypes, "storageTypes is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("storageKey", storageKey);
        params.put("storageTypes", storageTypes);
        return new Command<>("Storage.clearDataForStorageKey", Map.copyOf(params));
    }

    /**
     * Returns all browser cookies.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v136.network.model.Cookie>> getCookies(java.util.Optional<org.openqa.selenium.devtools.v136.browser.model.BrowserContextID> browserContextId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<>("Storage.getCookies", Map.copyOf(params), ConverterFunctions.map("cookies", input -> input.readArray(org.openqa.selenium.devtools.v136.network.model.Cookie.class)));
    }

    /**
     * Sets given cookies.
     */
    public static Command<Void> setCookies(java.util.List<org.openqa.selenium.devtools.v136.network.model.CookieParam> cookies, java.util.Optional<org.openqa.selenium.devtools.v136.browser.model.BrowserContextID> browserContextId) {
        java.util.Objects.requireNonNull(cookies, "cookies is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("cookies", cookies);
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<>("Storage.setCookies", Map.copyOf(params));
    }

    /**
     * Clears cookies.
     */
    public static Command<Void> clearCookies(java.util.Optional<org.openqa.selenium.devtools.v136.browser.model.BrowserContextID> browserContextId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<>("Storage.clearCookies", Map.copyOf(params));
    }

    public static class GetUsageAndQuotaResponse {

        private final java.lang.Number usage;

        private final java.lang.Number quota;

        private final java.lang.Boolean overrideActive;

        private final java.util.List<org.openqa.selenium.devtools.v136.storage.model.UsageForType> usageBreakdown;

        public GetUsageAndQuotaResponse(java.lang.Number usage, java.lang.Number quota, java.lang.Boolean overrideActive, java.util.List<org.openqa.selenium.devtools.v136.storage.model.UsageForType> usageBreakdown) {
            this.usage = java.util.Objects.requireNonNull(usage, "usage is required");
            this.quota = java.util.Objects.requireNonNull(quota, "quota is required");
            this.overrideActive = java.util.Objects.requireNonNull(overrideActive, "overrideActive is required");
            this.usageBreakdown = java.util.Objects.requireNonNull(usageBreakdown, "usageBreakdown is required");
        }

        /**
         * Storage usage (bytes).
         */
        public java.lang.Number getUsage() {
            return usage;
        }

        /**
         * Storage quota (bytes).
         */
        public java.lang.Number getQuota() {
            return quota;
        }

        /**
         * Whether or not the origin has an active storage quota override
         */
        public java.lang.Boolean getOverrideActive() {
            return overrideActive;
        }

        /**
         * Storage usage per type (bytes).
         */
        public java.util.List<org.openqa.selenium.devtools.v136.storage.model.UsageForType> getUsageBreakdown() {
            return usageBreakdown;
        }

        private static GetUsageAndQuotaResponse fromJson(JsonInput input) {
            java.lang.Number usage = 0;
            java.lang.Number quota = 0;
            java.lang.Boolean overrideActive = false;
            java.util.List<org.openqa.selenium.devtools.v136.storage.model.UsageForType> usageBreakdown = null;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "usage":
                        usage = input.nextNumber();
                        break;
                    case "quota":
                        quota = input.nextNumber();
                        break;
                    case "overrideActive":
                        overrideActive = input.nextBoolean();
                        break;
                    case "usageBreakdown":
                        usageBreakdown = input.readArray(org.openqa.selenium.devtools.v136.storage.model.UsageForType.class);
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetUsageAndQuotaResponse(usage, quota, overrideActive, usageBreakdown);
        }
    }

    /**
     * Returns usage and quota in bytes.
     */
    public static Command<org.openqa.selenium.devtools.v136.storage.Storage.GetUsageAndQuotaResponse> getUsageAndQuota(java.lang.String origin) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("origin", origin);
        return new Command<>("Storage.getUsageAndQuota", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v136.storage.Storage.GetUsageAndQuotaResponse.class));
    }

    /**
     * Override quota for the specified origin
     */
    @Beta()
    public static Command<Void> overrideQuotaForOrigin(java.lang.String origin, java.util.Optional<java.lang.Number> quotaSize) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("origin", origin);
        quotaSize.ifPresent(p -> params.put("quotaSize", p));
        return new Command<>("Storage.overrideQuotaForOrigin", Map.copyOf(params));
    }

    /**
     * Registers origin to be notified when an update occurs to its cache storage list.
     */
    public static Command<Void> trackCacheStorageForOrigin(java.lang.String origin) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("origin", origin);
        return new Command<>("Storage.trackCacheStorageForOrigin", Map.copyOf(params));
    }

    /**
     * Registers storage key to be notified when an update occurs to its cache storage list.
     */
    public static Command<Void> trackCacheStorageForStorageKey(java.lang.String storageKey) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("storageKey", storageKey);
        return new Command<>("Storage.trackCacheStorageForStorageKey", Map.copyOf(params));
    }

    /**
     * Registers origin to be notified when an update occurs to its IndexedDB.
     */
    public static Command<Void> trackIndexedDBForOrigin(java.lang.String origin) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("origin", origin);
        return new Command<>("Storage.trackIndexedDBForOrigin", Map.copyOf(params));
    }

    /**
     * Registers storage key to be notified when an update occurs to its IndexedDB.
     */
    public static Command<Void> trackIndexedDBForStorageKey(java.lang.String storageKey) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("storageKey", storageKey);
        return new Command<>("Storage.trackIndexedDBForStorageKey", Map.copyOf(params));
    }

    /**
     * Unregisters origin from receiving notifications for cache storage.
     */
    public static Command<Void> untrackCacheStorageForOrigin(java.lang.String origin) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("origin", origin);
        return new Command<>("Storage.untrackCacheStorageForOrigin", Map.copyOf(params));
    }

    /**
     * Unregisters storage key from receiving notifications for cache storage.
     */
    public static Command<Void> untrackCacheStorageForStorageKey(java.lang.String storageKey) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("storageKey", storageKey);
        return new Command<>("Storage.untrackCacheStorageForStorageKey", Map.copyOf(params));
    }

    /**
     * Unregisters origin from receiving notifications for IndexedDB.
     */
    public static Command<Void> untrackIndexedDBForOrigin(java.lang.String origin) {
        java.util.Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("origin", origin);
        return new Command<>("Storage.untrackIndexedDBForOrigin", Map.copyOf(params));
    }

    /**
     * Unregisters storage key from receiving notifications for IndexedDB.
     */
    public static Command<Void> untrackIndexedDBForStorageKey(java.lang.String storageKey) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("storageKey", storageKey);
        return new Command<>("Storage.untrackIndexedDBForStorageKey", Map.copyOf(params));
    }

    /**
     * Returns the number of stored Trust Tokens per issuer for the
     * current browsing context.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v136.storage.model.TrustTokens>> getTrustTokens() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Storage.getTrustTokens", Map.copyOf(params), ConverterFunctions.map("tokens", input -> input.readArray(org.openqa.selenium.devtools.v136.storage.model.TrustTokens.class)));
    }

    /**
     * Removes all Trust Tokens issued by the provided issuerOrigin.
     * Leaves other stored data, including the issuer's Redemption Records, intact.
     */
    @Beta()
    public static Command<java.lang.Boolean> clearTrustTokens(java.lang.String issuerOrigin) {
        java.util.Objects.requireNonNull(issuerOrigin, "issuerOrigin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("issuerOrigin", issuerOrigin);
        return new Command<>("Storage.clearTrustTokens", Map.copyOf(params), ConverterFunctions.map("didDeleteTokens", java.lang.Boolean.class));
    }

    /**
     * Gets details for a named interest group.
     */
    @Beta()
    public static Command<java.util.Map<String, Object>> getInterestGroupDetails(java.lang.String ownerOrigin, java.lang.String name) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        java.util.Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("ownerOrigin", ownerOrigin);
        params.put("name", name);
        return new Command<>("Storage.getInterestGroupDetails", Map.copyOf(params), ConverterFunctions.map("details", java.util.Map.class));
    }

    /**
     * Enables/Disables issuing of interestGroupAccessed events.
     */
    @Beta()
    public static Command<Void> setInterestGroupTracking(java.lang.Boolean enable) {
        java.util.Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enable", enable);
        return new Command<>("Storage.setInterestGroupTracking", Map.copyOf(params));
    }

    /**
     * Enables/Disables issuing of interestGroupAuctionEventOccurred and
     * interestGroupAuctionNetworkRequestCreated.
     */
    @Beta()
    public static Command<Void> setInterestGroupAuctionTracking(java.lang.Boolean enable) {
        java.util.Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enable", enable);
        return new Command<>("Storage.setInterestGroupAuctionTracking", Map.copyOf(params));
    }

    /**
     * Gets metadata for an origin's shared storage.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v136.storage.model.SharedStorageMetadata> getSharedStorageMetadata(java.lang.String ownerOrigin) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<>("Storage.getSharedStorageMetadata", Map.copyOf(params), ConverterFunctions.map("metadata", org.openqa.selenium.devtools.v136.storage.model.SharedStorageMetadata.class));
    }

    /**
     * Gets the entries in an given origin's shared storage.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v136.storage.model.SharedStorageEntry>> getSharedStorageEntries(java.lang.String ownerOrigin) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<>("Storage.getSharedStorageEntries", Map.copyOf(params), ConverterFunctions.map("entries", input -> input.readArray(org.openqa.selenium.devtools.v136.storage.model.SharedStorageEntry.class)));
    }

    /**
     * Sets entry with `key` and `value` for a given origin's shared storage.
     */
    @Beta()
    public static Command<Void> setSharedStorageEntry(java.lang.String ownerOrigin, java.lang.String key, java.lang.String value, java.util.Optional<java.lang.Boolean> ignoreIfPresent) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        java.util.Objects.requireNonNull(key, "key is required");
        java.util.Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("ownerOrigin", ownerOrigin);
        params.put("key", key);
        params.put("value", value);
        ignoreIfPresent.ifPresent(p -> params.put("ignoreIfPresent", p));
        return new Command<>("Storage.setSharedStorageEntry", Map.copyOf(params));
    }

    /**
     * Deletes entry for `key` (if it exists) for a given origin's shared storage.
     */
    @Beta()
    public static Command<Void> deleteSharedStorageEntry(java.lang.String ownerOrigin, java.lang.String key) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        java.util.Objects.requireNonNull(key, "key is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("ownerOrigin", ownerOrigin);
        params.put("key", key);
        return new Command<>("Storage.deleteSharedStorageEntry", Map.copyOf(params));
    }

    /**
     * Clears all entries for a given origin's shared storage.
     */
    @Beta()
    public static Command<Void> clearSharedStorageEntries(java.lang.String ownerOrigin) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<>("Storage.clearSharedStorageEntries", Map.copyOf(params));
    }

    /**
     * Resets the budget for `ownerOrigin` by clearing all budget withdrawals.
     */
    @Beta()
    public static Command<Void> resetSharedStorageBudget(java.lang.String ownerOrigin) {
        java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<>("Storage.resetSharedStorageBudget", Map.copyOf(params));
    }

    /**
     * Enables/disables issuing of sharedStorageAccessed events.
     */
    @Beta()
    public static Command<Void> setSharedStorageTracking(java.lang.Boolean enable) {
        java.util.Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enable", enable);
        return new Command<>("Storage.setSharedStorageTracking", Map.copyOf(params));
    }

    /**
     * Set tracking for a storage key's buckets.
     */
    @Beta()
    public static Command<Void> setStorageBucketTracking(java.lang.String storageKey, java.lang.Boolean enable) {
        java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        java.util.Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("storageKey", storageKey);
        params.put("enable", enable);
        return new Command<>("Storage.setStorageBucketTracking", Map.copyOf(params));
    }

    /**
     * Deletes the Storage Bucket with the given storage key and bucket name.
     */
    @Beta()
    public static Command<Void> deleteStorageBucket(org.openqa.selenium.devtools.v136.storage.model.StorageBucket bucket) {
        java.util.Objects.requireNonNull(bucket, "bucket is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("bucket", bucket);
        return new Command<>("Storage.deleteStorageBucket", Map.copyOf(params));
    }

    /**
     * Deletes state for sites identified as potential bounce trackers, immediately.
     */
    @Beta()
    public static Command<java.util.List<java.lang.String>> runBounceTrackingMitigations() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Storage.runBounceTrackingMitigations", Map.copyOf(params), ConverterFunctions.map("deletedSites", input -> input.readArray(java.lang.String.class)));
    }

    /**
     * https://wicg.github.io/attribution-reporting-api/
     */
    @Beta()
    public static Command<Void> setAttributionReportingLocalTestingMode(java.lang.Boolean enabled) {
        java.util.Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enabled", enabled);
        return new Command<>("Storage.setAttributionReportingLocalTestingMode", Map.copyOf(params));
    }

    /**
     * Enables/disables issuing of Attribution Reporting events.
     */
    @Beta()
    public static Command<Void> setAttributionReportingTracking(java.lang.Boolean enable) {
        java.util.Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enable", enable);
        return new Command<>("Storage.setAttributionReportingTracking", Map.copyOf(params));
    }

    /**
     * Sends all pending Attribution Reports immediately, regardless of their
     * scheduled report time.
     */
    @Beta()
    public static Command<java.lang.Integer> sendPendingAttributionReports() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Storage.sendPendingAttributionReports", Map.copyOf(params), ConverterFunctions.map("numSent", java.lang.Integer.class));
    }

    /**
     * Returns the effective Related Website Sets in use by this profile for the browser
     * session. The effective Related Website Sets will not change during a browser session.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v136.storage.model.RelatedWebsiteSet>> getRelatedWebsiteSets() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Storage.getRelatedWebsiteSets", Map.copyOf(params), ConverterFunctions.map("sets", input -> input.readArray(org.openqa.selenium.devtools.v136.storage.model.RelatedWebsiteSet.class)));
    }

    /**
     * Returns the list of URLs from a page and its embedded resources that match
     * existing grace period URL pattern rules.
     * https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/grace-period
     */
    @Beta()
    public static Command<java.util.List<java.lang.String>> getAffectedUrlsForThirdPartyCookieMetadata(java.lang.String firstPartyUrl, java.util.List<java.lang.String> thirdPartyUrls) {
        java.util.Objects.requireNonNull(firstPartyUrl, "firstPartyUrl is required");
        java.util.Objects.requireNonNull(thirdPartyUrls, "thirdPartyUrls is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("firstPartyUrl", firstPartyUrl);
        params.put("thirdPartyUrls", thirdPartyUrls);
        return new Command<>("Storage.getAffectedUrlsForThirdPartyCookieMetadata", Map.copyOf(params), ConverterFunctions.map("matchedUrls", input -> input.readArray(java.lang.String.class)));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.CacheStorageContentUpdated> cacheStorageContentUpdated() {
        return new Event<>("Storage.cacheStorageContentUpdated", input -> input.read(org.openqa.selenium.devtools.v136.storage.model.CacheStorageContentUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.CacheStorageListUpdated> cacheStorageListUpdated() {
        return new Event<>("Storage.cacheStorageListUpdated", input -> input.read(org.openqa.selenium.devtools.v136.storage.model.CacheStorageListUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.IndexedDBContentUpdated> indexedDBContentUpdated() {
        return new Event<>("Storage.indexedDBContentUpdated", input -> input.read(org.openqa.selenium.devtools.v136.storage.model.IndexedDBContentUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.IndexedDBListUpdated> indexedDBListUpdated() {
        return new Event<>("Storage.indexedDBListUpdated", input -> input.read(org.openqa.selenium.devtools.v136.storage.model.IndexedDBListUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.InterestGroupAccessed> interestGroupAccessed() {
        return new Event<>("Storage.interestGroupAccessed", input -> input.read(org.openqa.selenium.devtools.v136.storage.model.InterestGroupAccessed.class));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.InterestGroupAuctionEventOccurred> interestGroupAuctionEventOccurred() {
        return new Event<>("Storage.interestGroupAuctionEventOccurred", input -> input.read(org.openqa.selenium.devtools.v136.storage.model.InterestGroupAuctionEventOccurred.class));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.InterestGroupAuctionNetworkRequestCreated> interestGroupAuctionNetworkRequestCreated() {
        return new Event<>("Storage.interestGroupAuctionNetworkRequestCreated", input -> input.read(org.openqa.selenium.devtools.v136.storage.model.InterestGroupAuctionNetworkRequestCreated.class));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.SharedStorageAccessed> sharedStorageAccessed() {
        return new Event<>("Storage.sharedStorageAccessed", input -> input.read(org.openqa.selenium.devtools.v136.storage.model.SharedStorageAccessed.class));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.StorageBucketInfo> storageBucketCreatedOrUpdated() {
        return new Event<>("Storage.storageBucketCreatedOrUpdated", ConverterFunctions.map("bucketInfo", org.openqa.selenium.devtools.v136.storage.model.StorageBucketInfo.class));
    }

    public static Event<java.lang.String> storageBucketDeleted() {
        return new Event<>("Storage.storageBucketDeleted", ConverterFunctions.map("bucketId", java.lang.String.class));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.AttributionReportingSourceRegistered> attributionReportingSourceRegistered() {
        return new Event<>("Storage.attributionReportingSourceRegistered", input -> input.read(org.openqa.selenium.devtools.v136.storage.model.AttributionReportingSourceRegistered.class));
    }

    public static Event<org.openqa.selenium.devtools.v136.storage.model.AttributionReportingTriggerRegistered> attributionReportingTriggerRegistered() {
        return new Event<>("Storage.attributionReportingTriggerRegistered", input -> input.read(org.openqa.selenium.devtools.v136.storage.model.AttributionReportingTriggerRegistered.class));
    }
}
