/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.storage.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v136.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v136.storage.model.AttributionReportingAggregatableDebugReportingConfig;
import org.openqa.selenium.devtools.v136.storage.model.AttributionReportingAggregationKeysEntry;
import org.openqa.selenium.devtools.v136.storage.model.AttributionReportingFilterDataEntry;
import org.openqa.selenium.devtools.v136.storage.model.AttributionReportingSourceType;
import org.openqa.selenium.devtools.v136.storage.model.AttributionReportingTriggerDataMatching;
import org.openqa.selenium.devtools.v136.storage.model.AttributionReportingTriggerSpec;
import org.openqa.selenium.devtools.v136.storage.model.AttributionScopesData;
import org.openqa.selenium.devtools.v136.storage.model.SignedInt64AsBase10;
import org.openqa.selenium.devtools.v136.storage.model.UnsignedInt64AsBase10;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AttributionReportingSourceRegistration {
    private final TimeSinceEpoch time;
    private final Integer expiry;
    private final List<AttributionReportingTriggerSpec> triggerSpecs;
    private final Integer aggregatableReportWindow;
    private final AttributionReportingSourceType type;
    private final String sourceOrigin;
    private final String reportingOrigin;
    private final List<String> destinationSites;
    private final UnsignedInt64AsBase10 eventId;
    private final SignedInt64AsBase10 priority;
    private final List<AttributionReportingFilterDataEntry> filterData;
    private final List<AttributionReportingAggregationKeysEntry> aggregationKeys;
    private final Optional<UnsignedInt64AsBase10> debugKey;
    private final AttributionReportingTriggerDataMatching triggerDataMatching;
    private final SignedInt64AsBase10 destinationLimitPriority;
    private final AttributionReportingAggregatableDebugReportingConfig aggregatableDebugReportingConfig;
    private final Optional<AttributionScopesData> scopesData;
    private final Integer maxEventLevelReports;

    public AttributionReportingSourceRegistration(TimeSinceEpoch time, Integer expiry, List<AttributionReportingTriggerSpec> triggerSpecs, Integer aggregatableReportWindow, AttributionReportingSourceType type, String sourceOrigin, String reportingOrigin, List<String> destinationSites, UnsignedInt64AsBase10 eventId, SignedInt64AsBase10 priority, List<AttributionReportingFilterDataEntry> filterData, List<AttributionReportingAggregationKeysEntry> aggregationKeys, Optional<UnsignedInt64AsBase10> debugKey, AttributionReportingTriggerDataMatching triggerDataMatching, SignedInt64AsBase10 destinationLimitPriority, AttributionReportingAggregatableDebugReportingConfig aggregatableDebugReportingConfig, Optional<AttributionScopesData> scopesData, Integer maxEventLevelReports) {
        this.time = Objects.requireNonNull(time, "time is required");
        this.expiry = Objects.requireNonNull(expiry, "expiry is required");
        this.triggerSpecs = Objects.requireNonNull(triggerSpecs, "triggerSpecs is required");
        this.aggregatableReportWindow = Objects.requireNonNull(aggregatableReportWindow, "aggregatableReportWindow is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.sourceOrigin = Objects.requireNonNull(sourceOrigin, "sourceOrigin is required");
        this.reportingOrigin = Objects.requireNonNull(reportingOrigin, "reportingOrigin is required");
        this.destinationSites = Objects.requireNonNull(destinationSites, "destinationSites is required");
        this.eventId = Objects.requireNonNull(eventId, "eventId is required");
        this.priority = Objects.requireNonNull(priority, "priority is required");
        this.filterData = Objects.requireNonNull(filterData, "filterData is required");
        this.aggregationKeys = Objects.requireNonNull(aggregationKeys, "aggregationKeys is required");
        this.debugKey = debugKey;
        this.triggerDataMatching = Objects.requireNonNull(triggerDataMatching, "triggerDataMatching is required");
        this.destinationLimitPriority = Objects.requireNonNull(destinationLimitPriority, "destinationLimitPriority is required");
        this.aggregatableDebugReportingConfig = Objects.requireNonNull(aggregatableDebugReportingConfig, "aggregatableDebugReportingConfig is required");
        this.scopesData = scopesData;
        this.maxEventLevelReports = Objects.requireNonNull(maxEventLevelReports, "maxEventLevelReports is required");
    }

    public TimeSinceEpoch getTime() {
        return this.time;
    }

    public Integer getExpiry() {
        return this.expiry;
    }

    public List<AttributionReportingTriggerSpec> getTriggerSpecs() {
        return this.triggerSpecs;
    }

    public Integer getAggregatableReportWindow() {
        return this.aggregatableReportWindow;
    }

    public AttributionReportingSourceType getType() {
        return this.type;
    }

    public String getSourceOrigin() {
        return this.sourceOrigin;
    }

    public String getReportingOrigin() {
        return this.reportingOrigin;
    }

    public List<String> getDestinationSites() {
        return this.destinationSites;
    }

    public UnsignedInt64AsBase10 getEventId() {
        return this.eventId;
    }

    public SignedInt64AsBase10 getPriority() {
        return this.priority;
    }

    public List<AttributionReportingFilterDataEntry> getFilterData() {
        return this.filterData;
    }

    public List<AttributionReportingAggregationKeysEntry> getAggregationKeys() {
        return this.aggregationKeys;
    }

    public Optional<UnsignedInt64AsBase10> getDebugKey() {
        return this.debugKey;
    }

    public AttributionReportingTriggerDataMatching getTriggerDataMatching() {
        return this.triggerDataMatching;
    }

    public SignedInt64AsBase10 getDestinationLimitPriority() {
        return this.destinationLimitPriority;
    }

    public AttributionReportingAggregatableDebugReportingConfig getAggregatableDebugReportingConfig() {
        return this.aggregatableDebugReportingConfig;
    }

    public Optional<AttributionScopesData> getScopesData() {
        return this.scopesData;
    }

    public Integer getMaxEventLevelReports() {
        return this.maxEventLevelReports;
    }

    private static AttributionReportingSourceRegistration fromJson(JsonInput input) {
        TimeSinceEpoch time = null;
        Integer expiry = 0;
        List triggerSpecs = null;
        Integer aggregatableReportWindow = 0;
        AttributionReportingSourceType type = null;
        String sourceOrigin = null;
        String reportingOrigin = null;
        List destinationSites = null;
        UnsignedInt64AsBase10 eventId = null;
        SignedInt64AsBase10 priority = null;
        List filterData = null;
        List aggregationKeys = null;
        Optional<UnsignedInt64AsBase10> debugKey = Optional.empty();
        AttributionReportingTriggerDataMatching triggerDataMatching = null;
        SignedInt64AsBase10 destinationLimitPriority = null;
        AttributionReportingAggregatableDebugReportingConfig aggregatableDebugReportingConfig = null;
        Optional<AttributionScopesData> scopesData = Optional.empty();
        Integer maxEventLevelReports = 0;
        input.beginObject();
        block40: while (input.hasNext()) {
            switch (input.nextName()) {
                case "time": {
                    time = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block40;
                }
                case "expiry": {
                    expiry = input.nextNumber().intValue();
                    continue block40;
                }
                case "triggerSpecs": {
                    triggerSpecs = input.readArray(AttributionReportingTriggerSpec.class);
                    continue block40;
                }
                case "aggregatableReportWindow": {
                    aggregatableReportWindow = input.nextNumber().intValue();
                    continue block40;
                }
                case "type": {
                    type = (AttributionReportingSourceType)((Object)input.read(AttributionReportingSourceType.class));
                    continue block40;
                }
                case "sourceOrigin": {
                    sourceOrigin = input.nextString();
                    continue block40;
                }
                case "reportingOrigin": {
                    reportingOrigin = input.nextString();
                    continue block40;
                }
                case "destinationSites": {
                    destinationSites = input.readArray(String.class);
                    continue block40;
                }
                case "eventId": {
                    eventId = (UnsignedInt64AsBase10)input.read(UnsignedInt64AsBase10.class);
                    continue block40;
                }
                case "priority": {
                    priority = (SignedInt64AsBase10)input.read(SignedInt64AsBase10.class);
                    continue block40;
                }
                case "filterData": {
                    filterData = input.readArray(AttributionReportingFilterDataEntry.class);
                    continue block40;
                }
                case "aggregationKeys": {
                    aggregationKeys = input.readArray(AttributionReportingAggregationKeysEntry.class);
                    continue block40;
                }
                case "debugKey": {
                    debugKey = Optional.ofNullable((UnsignedInt64AsBase10)input.read(UnsignedInt64AsBase10.class));
                    continue block40;
                }
                case "triggerDataMatching": {
                    triggerDataMatching = (AttributionReportingTriggerDataMatching)((Object)input.read(AttributionReportingTriggerDataMatching.class));
                    continue block40;
                }
                case "destinationLimitPriority": {
                    destinationLimitPriority = (SignedInt64AsBase10)input.read(SignedInt64AsBase10.class);
                    continue block40;
                }
                case "aggregatableDebugReportingConfig": {
                    aggregatableDebugReportingConfig = (AttributionReportingAggregatableDebugReportingConfig)input.read(AttributionReportingAggregatableDebugReportingConfig.class);
                    continue block40;
                }
                case "scopesData": {
                    scopesData = Optional.ofNullable((AttributionScopesData)input.read(AttributionScopesData.class));
                    continue block40;
                }
                case "maxEventLevelReports": {
                    maxEventLevelReports = input.nextNumber().intValue();
                    continue block40;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingSourceRegistration(time, expiry, triggerSpecs, aggregatableReportWindow, type, sourceOrigin, reportingOrigin, destinationSites, eventId, priority, filterData, aggregationKeys, debugKey, triggerDataMatching, destinationLimitPriority, aggregatableDebugReportingConfig, scopesData, maxEventLevelReports);
    }
}

