/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.debugger.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v136.runtime.model.ScriptId;
import org.openqa.selenium.json.JsonInput;

public class BreakLocation {
    private final ScriptId scriptId;
    private final Integer lineNumber;
    private final Optional<Integer> columnNumber;
    private final Optional<Type> type;

    public BreakLocation(ScriptId scriptId, Integer lineNumber, Optional<Integer> columnNumber, Optional<Type> type) {
        this.scriptId = Objects.requireNonNull(scriptId, "scriptId is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = columnNumber;
        this.type = type;
    }

    public ScriptId getScriptId() {
        return this.scriptId;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Optional<Integer> getColumnNumber() {
        return this.columnNumber;
    }

    public Optional<Type> getType() {
        return this.type;
    }

    private static BreakLocation fromJson(JsonInput input) {
        ScriptId scriptId = null;
        Integer lineNumber = 0;
        Optional<Integer> columnNumber = Optional.empty();
        Optional<Type> type = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "scriptId": {
                    scriptId = (ScriptId)input.read(ScriptId.class);
                    continue block12;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block12;
                }
                case "columnNumber": {
                    columnNumber = Optional.ofNullable(input.nextNumber().intValue());
                    continue block12;
                }
                case "type": {
                    type = Optional.ofNullable(Type.fromString(input.nextString()));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BreakLocation(scriptId, lineNumber, columnNumber, type);
    }

    public static enum Type {
        DEBUGGERSTATEMENT("debuggerStatement"),
        CALL("call"),
        RETURN("return");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

