package org.openqa.selenium.devtools.v136.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class BackForwardCacheNotRestoredExplanation {

    private final org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredReasonType type;

    private final org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredReason reason;

    private final java.util.Optional<java.lang.String> context;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v136.page.model.BackForwardCacheBlockingDetails>> details;

    public BackForwardCacheNotRestoredExplanation(org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredReasonType type, org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredReason reason, java.util.Optional<java.lang.String> context, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v136.page.model.BackForwardCacheBlockingDetails>> details) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.reason = java.util.Objects.requireNonNull(reason, "reason is required");
        this.context = context;
        this.details = details;
    }

    /**
     * Type of the reason
     */
    public org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredReasonType getType() {
        return type;
    }

    /**
     * Not restored reason
     */
    public org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredReason getReason() {
        return reason;
    }

    /**
     * Context associated with the reason. The meaning of this context is
     * dependent on the reason:
     * - EmbedderExtensionSentMessageToCachedFrame: the extension ID.
     */
    public java.util.Optional<java.lang.String> getContext() {
        return context;
    }

    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v136.page.model.BackForwardCacheBlockingDetails>> getDetails() {
        return details;
    }

    private static BackForwardCacheNotRestoredExplanation fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredReasonType type = null;
        org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredReason reason = null;
        java.util.Optional<java.lang.String> context = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v136.page.model.BackForwardCacheBlockingDetails>> details = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredReasonType.class);
                    break;
                case "reason":
                    reason = input.read(org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredReason.class);
                    break;
                case "context":
                    context = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "details":
                    details = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v136.page.model.BackForwardCacheBlockingDetails.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BackForwardCacheNotRestoredExplanation(type, reason, context, details);
    }
}
