package org.openqa.selenium.devtools.v136.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS property at-rule representation.
 */
public class CSSPropertyRule {

    private final java.util.Optional<org.openqa.selenium.devtools.v136.css.model.StyleSheetId> styleSheetId;

    private final org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin origin;

    private final org.openqa.selenium.devtools.v136.css.model.Value propertyName;

    private final org.openqa.selenium.devtools.v136.css.model.CSSStyle style;

    public CSSPropertyRule(java.util.Optional<org.openqa.selenium.devtools.v136.css.model.StyleSheetId> styleSheetId, org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin origin, org.openqa.selenium.devtools.v136.css.model.Value propertyName, org.openqa.selenium.devtools.v136.css.model.CSSStyle style) {
        this.styleSheetId = styleSheetId;
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.propertyName = java.util.Objects.requireNonNull(propertyName, "propertyName is required");
        this.style = java.util.Objects.requireNonNull(style, "style is required");
    }

    /**
     * The css style sheet identifier (absent for user agent stylesheet and user-specified
     * stylesheet rules) this rule came from.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v136.css.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    /**
     * Parent stylesheet's origin.
     */
    public org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin getOrigin() {
        return origin;
    }

    /**
     * Associated property name.
     */
    public org.openqa.selenium.devtools.v136.css.model.Value getPropertyName() {
        return propertyName;
    }

    /**
     * Associated style declaration.
     */
    public org.openqa.selenium.devtools.v136.css.model.CSSStyle getStyle() {
        return style;
    }

    private static CSSPropertyRule fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v136.css.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin origin = null;
        org.openqa.selenium.devtools.v136.css.model.Value propertyName = null;
        org.openqa.selenium.devtools.v136.css.model.CSSStyle style = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v136.css.model.StyleSheetId.class));
                    break;
                case "origin":
                    origin = input.read(org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin.class);
                    break;
                case "propertyName":
                    propertyName = input.read(org.openqa.selenium.devtools.v136.css.model.Value.class);
                    break;
                case "style":
                    style = input.read(org.openqa.selenium.devtools.v136.css.model.CSSStyle.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSPropertyRule(styleSheetId, origin, propertyName, style);
    }
}
