/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.page.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v135.network.model.LoaderId;
import org.openqa.selenium.devtools.v135.page.model.AdFrameStatus;
import org.openqa.selenium.devtools.v135.page.model.CrossOriginIsolatedContextType;
import org.openqa.selenium.devtools.v135.page.model.FrameId;
import org.openqa.selenium.devtools.v135.page.model.GatedAPIFeatures;
import org.openqa.selenium.devtools.v135.page.model.SecureContextType;
import org.openqa.selenium.devtools.v135.page.model.SecurityOriginDetails;
import org.openqa.selenium.json.JsonInput;

public class Frame {
    private final FrameId id;
    private final Optional<FrameId> parentId;
    private final LoaderId loaderId;
    private final Optional<String> name;
    private final String url;
    private final Optional<String> urlFragment;
    private final String domainAndRegistry;
    private final String securityOrigin;
    private final Optional<SecurityOriginDetails> securityOriginDetails;
    private final String mimeType;
    private final Optional<String> unreachableUrl;
    private final Optional<AdFrameStatus> adFrameStatus;
    private final SecureContextType secureContextType;
    private final CrossOriginIsolatedContextType crossOriginIsolatedContextType;
    private final List<GatedAPIFeatures> gatedAPIFeatures;

    public Frame(FrameId id, Optional<FrameId> parentId, LoaderId loaderId, Optional<String> name, String url, Optional<String> urlFragment, String domainAndRegistry, String securityOrigin, Optional<SecurityOriginDetails> securityOriginDetails, String mimeType, Optional<String> unreachableUrl, Optional<AdFrameStatus> adFrameStatus, SecureContextType secureContextType, CrossOriginIsolatedContextType crossOriginIsolatedContextType, List<GatedAPIFeatures> gatedAPIFeatures) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.parentId = parentId;
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.name = name;
        this.url = Objects.requireNonNull(url, "url is required");
        this.urlFragment = urlFragment;
        this.domainAndRegistry = Objects.requireNonNull(domainAndRegistry, "domainAndRegistry is required");
        this.securityOrigin = Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        this.securityOriginDetails = securityOriginDetails;
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType is required");
        this.unreachableUrl = unreachableUrl;
        this.adFrameStatus = adFrameStatus;
        this.secureContextType = Objects.requireNonNull(secureContextType, "secureContextType is required");
        this.crossOriginIsolatedContextType = Objects.requireNonNull(crossOriginIsolatedContextType, "crossOriginIsolatedContextType is required");
        this.gatedAPIFeatures = Objects.requireNonNull(gatedAPIFeatures, "gatedAPIFeatures is required");
    }

    public FrameId getId() {
        return this.id;
    }

    public Optional<FrameId> getParentId() {
        return this.parentId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    @Beta
    public Optional<String> getUrlFragment() {
        return this.urlFragment;
    }

    @Beta
    public String getDomainAndRegistry() {
        return this.domainAndRegistry;
    }

    public String getSecurityOrigin() {
        return this.securityOrigin;
    }

    @Beta
    public Optional<SecurityOriginDetails> getSecurityOriginDetails() {
        return this.securityOriginDetails;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Beta
    public Optional<String> getUnreachableUrl() {
        return this.unreachableUrl;
    }

    @Beta
    public Optional<AdFrameStatus> getAdFrameStatus() {
        return this.adFrameStatus;
    }

    @Beta
    public SecureContextType getSecureContextType() {
        return this.secureContextType;
    }

    @Beta
    public CrossOriginIsolatedContextType getCrossOriginIsolatedContextType() {
        return this.crossOriginIsolatedContextType;
    }

    @Beta
    public List<GatedAPIFeatures> getGatedAPIFeatures() {
        return this.gatedAPIFeatures;
    }

    private static Frame fromJson(JsonInput input) {
        FrameId id = null;
        Optional<FrameId> parentId = Optional.empty();
        LoaderId loaderId = null;
        Optional<String> name = Optional.empty();
        String url = null;
        Optional<String> urlFragment = Optional.empty();
        String domainAndRegistry = null;
        String securityOrigin = null;
        Optional<SecurityOriginDetails> securityOriginDetails = Optional.empty();
        String mimeType = null;
        Optional<String> unreachableUrl = Optional.empty();
        Optional<AdFrameStatus> adFrameStatus = Optional.empty();
        SecureContextType secureContextType = null;
        CrossOriginIsolatedContextType crossOriginIsolatedContextType = null;
        List gatedAPIFeatures = null;
        input.beginObject();
        block34: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (FrameId)input.read(FrameId.class);
                    continue block34;
                }
                case "parentId": {
                    parentId = Optional.ofNullable((FrameId)input.read(FrameId.class));
                    continue block34;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block34;
                }
                case "name": {
                    name = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "url": {
                    url = input.nextString();
                    continue block34;
                }
                case "urlFragment": {
                    urlFragment = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "domainAndRegistry": {
                    domainAndRegistry = input.nextString();
                    continue block34;
                }
                case "securityOrigin": {
                    securityOrigin = input.nextString();
                    continue block34;
                }
                case "securityOriginDetails": {
                    securityOriginDetails = Optional.ofNullable((SecurityOriginDetails)input.read(SecurityOriginDetails.class));
                    continue block34;
                }
                case "mimeType": {
                    mimeType = input.nextString();
                    continue block34;
                }
                case "unreachableUrl": {
                    unreachableUrl = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "adFrameStatus": {
                    adFrameStatus = Optional.ofNullable((AdFrameStatus)input.read(AdFrameStatus.class));
                    continue block34;
                }
                case "secureContextType": {
                    secureContextType = (SecureContextType)((Object)input.read(SecureContextType.class));
                    continue block34;
                }
                case "crossOriginIsolatedContextType": {
                    crossOriginIsolatedContextType = (CrossOriginIsolatedContextType)((Object)input.read(CrossOriginIsolatedContextType.class));
                    continue block34;
                }
                case "gatedAPIFeatures": {
                    gatedAPIFeatures = input.readArray(GatedAPIFeatures.class);
                    continue block34;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Frame(id, parentId, loaderId, name, url, urlFragment, domainAndRegistry, securityOrigin, securityOriginDetails, mimeType, unreachableUrl, adFrameStatus, secureContextType, crossOriginIsolatedContextType, gatedAPIFeatures);
    }
}

