package org.openqa.selenium.devtools.v135.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class SensorMetadata {

    private final java.util.Optional<java.lang.Boolean> available;

    private final java.util.Optional<java.lang.Number> minimumFrequency;

    private final java.util.Optional<java.lang.Number> maximumFrequency;

    public SensorMetadata(java.util.Optional<java.lang.Boolean> available, java.util.Optional<java.lang.Number> minimumFrequency, java.util.Optional<java.lang.Number> maximumFrequency) {
        this.available = available;
        this.minimumFrequency = minimumFrequency;
        this.maximumFrequency = maximumFrequency;
    }

    public java.util.Optional<java.lang.Boolean> getAvailable() {
        return available;
    }

    public java.util.Optional<java.lang.Number> getMinimumFrequency() {
        return minimumFrequency;
    }

    public java.util.Optional<java.lang.Number> getMaximumFrequency() {
        return maximumFrequency;
    }

    private static SensorMetadata fromJson(JsonInput input) {
        java.util.Optional<java.lang.Boolean> available = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> minimumFrequency = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> maximumFrequency = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "available":
                    available = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "minimumFrequency":
                    minimumFrequency = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "maximumFrequency":
                    maximumFrequency = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SensorMetadata(available, minimumFrequency, maximumFrequency);
    }
}
