/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.fetch.model;

import java.util.Optional;
import org.openqa.selenium.devtools.v135.fetch.model.RequestStage;
import org.openqa.selenium.devtools.v135.network.model.ResourceType;
import org.openqa.selenium.json.JsonInput;

public class RequestPattern {
    private final Optional<String> urlPattern;
    private final Optional<ResourceType> resourceType;
    private final Optional<RequestStage> requestStage;

    public RequestPattern(Optional<String> urlPattern, Optional<ResourceType> resourceType, Optional<RequestStage> requestStage) {
        this.urlPattern = urlPattern;
        this.resourceType = resourceType;
        this.requestStage = requestStage;
    }

    public Optional<String> getUrlPattern() {
        return this.urlPattern;
    }

    public Optional<ResourceType> getResourceType() {
        return this.resourceType;
    }

    public Optional<RequestStage> getRequestStage() {
        return this.requestStage;
    }

    private static RequestPattern fromJson(JsonInput input) {
        Optional<String> urlPattern = Optional.empty();
        Optional<ResourceType> resourceType = Optional.empty();
        Optional<RequestStage> requestStage = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "urlPattern": {
                    urlPattern = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "resourceType": {
                    resourceType = Optional.ofNullable((ResourceType)((Object)input.read(ResourceType.class)));
                    continue block10;
                }
                case "requestStage": {
                    requestStage = Optional.ofNullable((RequestStage)((Object)input.read(RequestStage.class)));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestPattern(urlPattern, resourceType, requestStage);
    }
}

