package org.openqa.selenium.devtools.v135.webauthn;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain allows configuring virtual authenticators to test the WebAuthn
 * API.
 */
@Beta()
public class WebAuthn {

    /**
     * Enable the WebAuthn domain and start intercepting credential storage and
     * retrieval with a virtual authenticator.
     */
    public static Command<Void> enable(java.util.Optional<java.lang.Boolean> enableUI) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        enableUI.ifPresent(p -> params.put("enableUI", p));
        return new Command<>("WebAuthn.enable", Map.copyOf(params));
    }

    /**
     * Disable the WebAuthn domain.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("WebAuthn.disable", Map.copyOf(params));
    }

    /**
     * Creates and adds a virtual authenticator.
     */
    public static Command<org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId> addVirtualAuthenticator(org.openqa.selenium.devtools.v135.webauthn.model.VirtualAuthenticatorOptions options) {
        java.util.Objects.requireNonNull(options, "options is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("options", options);
        return new Command<>("WebAuthn.addVirtualAuthenticator", Map.copyOf(params), ConverterFunctions.map("authenticatorId", org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId.class));
    }

    /**
     * Resets parameters isBogusSignature, isBadUV, isBadUP to false if they are not present.
     */
    public static Command<Void> setResponseOverrideBits(org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId authenticatorId, java.util.Optional<java.lang.Boolean> isBogusSignature, java.util.Optional<java.lang.Boolean> isBadUV, java.util.Optional<java.lang.Boolean> isBadUP) {
        java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("authenticatorId", authenticatorId);
        isBogusSignature.ifPresent(p -> params.put("isBogusSignature", p));
        isBadUV.ifPresent(p -> params.put("isBadUV", p));
        isBadUP.ifPresent(p -> params.put("isBadUP", p));
        return new Command<>("WebAuthn.setResponseOverrideBits", Map.copyOf(params));
    }

    /**
     * Removes the given authenticator.
     */
    public static Command<Void> removeVirtualAuthenticator(org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId authenticatorId) {
        java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("authenticatorId", authenticatorId);
        return new Command<>("WebAuthn.removeVirtualAuthenticator", Map.copyOf(params));
    }

    /**
     * Adds the credential to the specified authenticator.
     */
    public static Command<Void> addCredential(org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId authenticatorId, org.openqa.selenium.devtools.v135.webauthn.model.Credential credential) {
        java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        java.util.Objects.requireNonNull(credential, "credential is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("authenticatorId", authenticatorId);
        params.put("credential", credential);
        return new Command<>("WebAuthn.addCredential", Map.copyOf(params));
    }

    /**
     * Returns a single credential stored in the given virtual authenticator that
     * matches the credential ID.
     */
    public static Command<org.openqa.selenium.devtools.v135.webauthn.model.Credential> getCredential(org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId authenticatorId, java.lang.String credentialId) {
        java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        java.util.Objects.requireNonNull(credentialId, "credentialId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("authenticatorId", authenticatorId);
        params.put("credentialId", credentialId);
        return new Command<>("WebAuthn.getCredential", Map.copyOf(params), ConverterFunctions.map("credential", org.openqa.selenium.devtools.v135.webauthn.model.Credential.class));
    }

    /**
     * Returns all the credentials stored in the given virtual authenticator.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v135.webauthn.model.Credential>> getCredentials(org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId authenticatorId) {
        java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("authenticatorId", authenticatorId);
        return new Command<>("WebAuthn.getCredentials", Map.copyOf(params), ConverterFunctions.map("credentials", input -> input.readArray(org.openqa.selenium.devtools.v135.webauthn.model.Credential.class)));
    }

    /**
     * Removes a credential from the authenticator.
     */
    public static Command<Void> removeCredential(org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId authenticatorId, java.lang.String credentialId) {
        java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        java.util.Objects.requireNonNull(credentialId, "credentialId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("authenticatorId", authenticatorId);
        params.put("credentialId", credentialId);
        return new Command<>("WebAuthn.removeCredential", Map.copyOf(params));
    }

    /**
     * Clears all the credentials from the specified device.
     */
    public static Command<Void> clearCredentials(org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId authenticatorId) {
        java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("authenticatorId", authenticatorId);
        return new Command<>("WebAuthn.clearCredentials", Map.copyOf(params));
    }

    /**
     * Sets whether User Verification succeeds or fails for an authenticator.
     * The default is true.
     */
    public static Command<Void> setUserVerified(org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId authenticatorId, java.lang.Boolean isUserVerified) {
        java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        java.util.Objects.requireNonNull(isUserVerified, "isUserVerified is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("authenticatorId", authenticatorId);
        params.put("isUserVerified", isUserVerified);
        return new Command<>("WebAuthn.setUserVerified", Map.copyOf(params));
    }

    /**
     * Sets whether tests of user presence will succeed immediately (if true) or fail to resolve (if false) for an authenticator.
     * The default is true.
     */
    public static Command<Void> setAutomaticPresenceSimulation(org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId authenticatorId, java.lang.Boolean enabled) {
        java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        java.util.Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("authenticatorId", authenticatorId);
        params.put("enabled", enabled);
        return new Command<>("WebAuthn.setAutomaticPresenceSimulation", Map.copyOf(params));
    }

    /**
     * Allows setting credential properties.
     * https://w3c.github.io/webauthn/#sctn-automation-set-credential-properties
     */
    public static Command<Void> setCredentialProperties(org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId authenticatorId, java.lang.String credentialId, java.util.Optional<java.lang.Boolean> backupEligibility, java.util.Optional<java.lang.Boolean> backupState) {
        java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        java.util.Objects.requireNonNull(credentialId, "credentialId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("authenticatorId", authenticatorId);
        params.put("credentialId", credentialId);
        backupEligibility.ifPresent(p -> params.put("backupEligibility", p));
        backupState.ifPresent(p -> params.put("backupState", p));
        return new Command<>("WebAuthn.setCredentialProperties", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v135.webauthn.model.CredentialAdded> credentialAdded() {
        return new Event<>("WebAuthn.credentialAdded", input -> input.read(org.openqa.selenium.devtools.v135.webauthn.model.CredentialAdded.class));
    }

    public static Event<org.openqa.selenium.devtools.v135.webauthn.model.CredentialDeleted> credentialDeleted() {
        return new Event<>("WebAuthn.credentialDeleted", input -> input.read(org.openqa.selenium.devtools.v135.webauthn.model.CredentialDeleted.class));
    }

    public static Event<org.openqa.selenium.devtools.v135.webauthn.model.CredentialUpdated> credentialUpdated() {
        return new Event<>("WebAuthn.credentialUpdated", input -> input.read(org.openqa.selenium.devtools.v135.webauthn.model.CredentialUpdated.class));
    }

    public static Event<org.openqa.selenium.devtools.v135.webauthn.model.CredentialAsserted> credentialAsserted() {
        return new Event<>("WebAuthn.credentialAsserted", input -> input.read(org.openqa.selenium.devtools.v135.webauthn.model.CredentialAsserted.class));
    }
}
