package org.openqa.selenium.devtools.v135.media.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Send a list of any messages that need to be delivered.
 */
public class PlayerMessagesLogged {

    private final org.openqa.selenium.devtools.v135.media.model.PlayerId playerId;

    private final java.util.List<org.openqa.selenium.devtools.v135.media.model.PlayerMessage> messages;

    public PlayerMessagesLogged(org.openqa.selenium.devtools.v135.media.model.PlayerId playerId, java.util.List<org.openqa.selenium.devtools.v135.media.model.PlayerMessage> messages) {
        this.playerId = java.util.Objects.requireNonNull(playerId, "playerId is required");
        this.messages = java.util.Objects.requireNonNull(messages, "messages is required");
    }

    public org.openqa.selenium.devtools.v135.media.model.PlayerId getPlayerId() {
        return playerId;
    }

    public java.util.List<org.openqa.selenium.devtools.v135.media.model.PlayerMessage> getMessages() {
        return messages;
    }

    private static PlayerMessagesLogged fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v135.media.model.PlayerId playerId = null;
        java.util.List<org.openqa.selenium.devtools.v135.media.model.PlayerMessage> messages = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "playerId":
                    playerId = input.read(org.openqa.selenium.devtools.v135.media.model.PlayerId.class);
                    break;
                case "messages":
                    messages = input.readArray(org.openqa.selenium.devtools.v135.media.model.PlayerMessage.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PlayerMessagesLogged(playerId, messages);
    }
}
