package org.openqa.selenium.devtools.v135.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum CookieWarningReason {

    WARNSAMESITEUNSPECIFIEDCROSSSITECONTEXT("WarnSameSiteUnspecifiedCrossSiteContext"),
    WARNSAMESITENONEINSECURE("WarnSameSiteNoneInsecure"),
    WARNSAMESITEUNSPECIFIEDLAXALLOWUNSAFE("WarnSameSiteUnspecifiedLaxAllowUnsafe"),
    WARNSAMESITESTRICTLAXDOWNGRADESTRICT("WarnSameSiteStrictLaxDowngradeStrict"),
    WARNSAMESITESTRICTCROSSDOWNGRADESTRICT("WarnSameSiteStrictCrossDowngradeStrict"),
    WARNSAMESITESTRICTCROSSDOWNGRADELAX("WarnSameSiteStrictCrossDowngradeLax"),
    WARNSAMESITELAXCROSSDOWNGRADESTRICT("WarnSameSiteLaxCrossDowngradeStrict"),
    WARNSAMESITELAXCROSSDOWNGRADELAX("WarnSameSiteLaxCrossDowngradeLax"),
    WARNATTRIBUTEVALUEEXCEEDSMAXSIZE("WarnAttributeValueExceedsMaxSize"),
    WARNDOMAINNONASCII("WarnDomainNonASCII"),
    WARNTHIRDPARTYPHASEOUT("WarnThirdPartyPhaseout"),
    WARNCROSSSITEREDIRECTDOWNGRADECHANGESINCLUSION("WarnCrossSiteRedirectDowngradeChangesInclusion"),
    WARNDEPRECATIONTRIALMETADATA("WarnDeprecationTrialMetadata"),
    WARNTHIRDPARTYCOOKIEHEURISTIC("WarnThirdPartyCookieHeuristic");

    private String value;

    CookieWarningReason(String value) {
        this.value = value;
    }

    public static CookieWarningReason fromString(String s) {
        return java.util.Arrays.stream(CookieWarningReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CookieWarningReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CookieWarningReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
