/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v134.heapprofiler.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class SamplingHeapProfileSample {
    private final Number size;
    private final Integer nodeId;
    private final Number ordinal;

    public SamplingHeapProfileSample(Number size, Integer nodeId, Number ordinal) {
        this.size = Objects.requireNonNull(size, "size is required");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.ordinal = Objects.requireNonNull(ordinal, "ordinal is required");
    }

    public Number getSize() {
        return this.size;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public Number getOrdinal() {
        return this.ordinal;
    }

    private static SamplingHeapProfileSample fromJson(JsonInput input) {
        Number size = 0;
        Integer nodeId = 0;
        Number ordinal = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "size": {
                    size = input.nextNumber();
                    continue block10;
                }
                case "nodeId": {
                    nodeId = input.nextNumber().intValue();
                    continue block10;
                }
                case "ordinal": {
                    ordinal = input.nextNumber();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SamplingHeapProfileSample(size, nodeId, ordinal);
    }
}

