package org.openqa.selenium.devtools.v134.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Chrome manages different types of preloads together using a
 * concept of preloading pipeline. For example, if a site uses a
 * SpeculationRules for prerender, Chrome first starts a prefetch and
 * then upgrades it to prerender.
 *
 * CDP events for them are emitted separately but they share
 * `PreloadPipelineId`.
 */
public class PreloadPipelineId {

    private final java.lang.String preloadPipelineId;

    public PreloadPipelineId(java.lang.String preloadPipelineId) {
        this.preloadPipelineId = java.util.Objects.requireNonNull(preloadPipelineId, "Missing value for PreloadPipelineId");
    }

    private static PreloadPipelineId fromJson(JsonInput input) {
        return new PreloadPipelineId(input.nextString());
    }

    public String toJson() {
        return preloadPipelineId.toString();
    }

    public String toString() {
        return preloadPipelineId.toString();
    }
}
