package org.openqa.selenium.devtools.v133.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Style information for drawing a box.
 */
public class BoxStyle {

    private final java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.RGBA> fillColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.RGBA> hatchColor;

    public BoxStyle(java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.RGBA> fillColor, java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.RGBA> hatchColor) {
        this.fillColor = fillColor;
        this.hatchColor = hatchColor;
    }

    /**
     * The background color for the box (default: transparent)
     */
    public java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.RGBA> getFillColor() {
        return fillColor;
    }

    /**
     * The hatching color for the box (default: transparent)
     */
    public java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.RGBA> getHatchColor() {
        return hatchColor;
    }

    private static BoxStyle fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.RGBA> fillColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.RGBA> hatchColor = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "fillColor":
                    fillColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v133.dom.model.RGBA.class));
                    break;
                case "hatchColor":
                    hatchColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v133.dom.model.RGBA.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BoxStyle(fillColor, hatchColor);
    }
}
