/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.headlessexperimental;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.v132.headlessexperimental.model.ScreenshotParams;
import org.openqa.selenium.json.JsonInput;

@Beta
public class HeadlessExperimental {
    public static Command<BeginFrameResponse> beginFrame(Optional<Number> frameTimeTicks, Optional<Number> interval, Optional<Boolean> noDisplayUpdates, Optional<ScreenshotParams> screenshot) {
        LinkedHashMap params = new LinkedHashMap();
        frameTimeTicks.ifPresent(p -> params.put("frameTimeTicks", p));
        interval.ifPresent(p -> params.put("interval", p));
        noDisplayUpdates.ifPresent(p -> params.put("noDisplayUpdates", p));
        screenshot.ifPresent(p -> params.put("screenshot", p));
        return new Command("HeadlessExperimental.beginFrame", Map.copyOf(params), input -> (BeginFrameResponse)input.read(BeginFrameResponse.class));
    }

    @Deprecated
    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("HeadlessExperimental.disable", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("HeadlessExperimental.enable", Map.copyOf(params));
    }

    public static class BeginFrameResponse {
        private final Boolean hasDamage;
        private final Optional<String> screenshotData;

        public BeginFrameResponse(Boolean hasDamage, Optional<String> screenshotData) {
            this.hasDamage = Objects.requireNonNull(hasDamage, "hasDamage is required");
            this.screenshotData = screenshotData;
        }

        public Boolean getHasDamage() {
            return this.hasDamage;
        }

        public Optional<String> getScreenshotData() {
            return this.screenshotData;
        }

        private static BeginFrameResponse fromJson(JsonInput input) {
            Boolean hasDamage = false;
            Optional<String> screenshotData = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "hasDamage": {
                        hasDamage = input.nextBoolean();
                        continue block8;
                    }
                    case "screenshotData": {
                        screenshotData = Optional.ofNullable(input.nextString());
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new BeginFrameResponse(hasDamage, screenshotData);
        }
    }
}

